/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.item;

import com.jeff_media.customblockdata.CustomBlockData;
import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Antiglitch;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.integrations.ItemsAdderEnabled;
import com.ordwen.odailyquests.externs.hooks.items.KGeneratorsHook;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import dev.lone.itemsadder.api.CustomBlock;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class BlockBreakListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreakEvent(BlockBreakEvent event) {
        CustomBlock customBlock;
        Debugger.write("BlockBreakListener: onBlockBreakEvent summoned.");
        if (event.isCancelled()) {
            Debugger.write("BlockBreakListener: onBlockBreakEvent cancelled.");
            return;
        }
        Block block = event.getBlock();
        Material material = block.getType();
        Debugger.write("BlockBreakListener: onBlockBreakEvent block type: " + material.name() + ".");
        if (ItemsAdderEnabled.isEnabled() && (customBlock = CustomBlock.byAlreadyPlaced((Block)block)) != null) {
            Debugger.write("BlockBreakListener: onBlockBreakEvent cancelled due to ItemsAdder custom block.");
            return;
        }
        if (VERTICAL_PLANTS_UP.contains(material)) {
            Debugger.write("BlockBreakListener: onBlockBreakEvent vertical plant detected (UP).");
            this.handleVerticalPlant(event, material, BlockFace.UP);
            return;
        }
        if (VERTICAL_PLANTS_DOWN.contains(material)) {
            Debugger.write("BlockBreakListener: onBlockBreakEvent vertical plant detected (DOWN).");
            this.handleVerticalPlant(event, material, BlockFace.DOWN);
            return;
        }
        if (this.canProgress(block)) {
            Player player = event.getPlayer();
            Debugger.write("BlockBreakListener: onBlockBreakEvent summoned by " + player.getName() + " for " + String.valueOf(block.getType()) + ".");
            this.setPlayerQuestProgression((Event)event, player, 1, "BREAK");
        }
    }

    private boolean canProgress(Block block) {
        if (Antiglitch.isStorePlacedBlocks()) {
            Ageable ageable;
            Debugger.write("BlockBreakListener: onBlockBreakEvent checking for placed blocks.");
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Ageable && (ageable = (Ageable)blockData).getAge() != ageable.getMaximumAge()) {
                Debugger.write("BlockBreakListener: onBlockBreakEvent cancelled due to ageable block.");
                return false;
            }
            CustomBlockData pdc = new CustomBlockData(block, (Plugin)ODailyQuests.INSTANCE);
            if (pdc.has(Antiglitch.PLACED_KEY)) {
                if (KGeneratorsHook.isKGeneratorsLocation(block.getLocation())) {
                    Debugger.write("BlockBreakListener: onBlockBreakEvent processing KGenerators generator.");
                } else {
                    Debugger.write("BlockBreakListener: onBlockBreakEvent cancelled due to placed block.");
                    return false;
                }
            }
            Debugger.write("BlockBreakListener: onBlockBreakEvent placed block check complete.");
        }
        return true;
    }

    private void handleVerticalPlant(BlockBreakEvent event, Material plantType, BlockFace blockFace) {
        Block relativeBlock = event.getBlock();
        int count = 0;
        while (relativeBlock.getType() == plantType) {
            if (this.isValidForQuestProgression(relativeBlock)) {
                ++count;
            }
            relativeBlock = relativeBlock.getRelative(blockFace);
        }
        Debugger.write("BlockBreakListener: handleVerticalPlant found " + count + " vertical plant blocks.");
        if (count > 0) {
            Debugger.write(count + " vertical plant blocks found.");
            this.setPlayerQuestProgression((Event)event, event.getPlayer(), count, "FARMING");
        } else {
            Debugger.write("BlockBreakListener: handleVerticalPlant cancelled due to placed blocks.");
        }
    }

    private boolean isValidForQuestProgression(Block block) {
        if (!Antiglitch.isStorePlacedBlocks()) {
            return true;
        }
        CustomBlockData pdc = new CustomBlockData(block, (Plugin)ODailyQuests.INSTANCE);
        if (pdc.has(Antiglitch.PLACED_KEY)) {
            Debugger.write("BlockBreakListener: isBlockCountable cancelled due to placed block.");
            return false;
        }
        return true;
    }
}

