/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.item;

import com.ordwen.odailyquests.configuration.essentials.Antiglitch;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.events.listeners.item.custom.DropQueuePushListener;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import com.ordwen.odailyquests.tools.PluginUtils;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class BlockDropItemListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockDropItem(BlockDropItemEvent event) {
        Debugger.write("BlockDropItemListener: onBlockDropItemEvent summoned.");
        if (event.isCancelled()) {
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent is cancelled.");
            return;
        }
        Player player = event.getPlayer();
        BlockData data = event.getBlockState().getBlockData();
        Material dataMaterial = data.getMaterial();
        if (BlockDropItemListener.isVerticalPlant(dataMaterial)) {
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent vertical plant detected, skipping drop handling.");
            return;
        }
        if (PluginUtils.isPluginEnabled("eco")) {
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent eco is enabled. Setting current state for DropQueuePushListener.");
            DropQueuePushListener.setCurrentState(event.getBlockState());
        }
        Debugger.write("BlockDropItemListener: onBlockDropItemEvent block data: " + dataMaterial.name() + ".");
        List drops = event.getItems();
        if (drops.isEmpty()) {
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent no drops.");
            return;
        }
        if (this.isAgeableAndFullyGrown((Event)event, data, dataMaterial, player, drops)) {
            return;
        }
        if (this.isPlayerPlacedBlock(event.getBlock(), dataMaterial)) {
            return;
        }
        this.handleDrops((Event)event, player, drops);
        this.handleStoreBrokenBlocks(drops, player, dataMaterial);
    }

    private boolean isAgeableAndFullyGrown(Event event, BlockData data, Material dataMaterial, Player player, List<Item> drops) {
        if (BlockDropItemListener.isVerticalPlant(dataMaterial)) {
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent vertical plant detected, skipping ageable check.");
            return false;
        }
        if (data instanceof Ageable) {
            Ageable ageable = (Ageable)data;
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent ageable block: " + String.valueOf(dataMaterial) + ".");
            if (ageable.getAge() == ageable.getMaximumAge()) {
                Debugger.write("BlockDropItemListener: onBlockDropItemEvent ageable block is mature.");
                this.handleDrops(event, player, drops);
                return true;
            }
        }
        return false;
    }

    private void handleStoreBrokenBlocks(List<Item> drops, Player player, Material material) {
        if (material.isBlock() && Antiglitch.isStoreBrokenBlocks()) {
            Debugger.write("BlockDropItemListener: onBlockDropItemEvent storing broken block.");
            List<ItemStack> itemStacks = drops.stream().map(Item::getItemStack).toList();
            this.storeBrokenBlockMetadata(itemStacks, player);
        }
    }
}

