/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.item;

import com.jeff_media.customblockdata.CustomBlockData;
import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Antiglitch;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockPlaceListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlaceEvent(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        boolean valid = true;
        if (Antiglitch.isStoreBrokenBlocks()) {
            PersistentDataContainer pdc;
            String placedItemKey;
            Debugger.write("BlockPlaceListener: onBlockPlaceEvent checking for broken blocks.");
            ItemStack placedItem = player.getInventory().getItemInMainHand();
            ItemMeta placedItemMeta = placedItem.getItemMeta();
            if (placedItemMeta != null && (placedItemKey = (String)(pdc = placedItemMeta.getPersistentDataContainer()).get(Antiglitch.BROKEN_KEY, PersistentDataType.STRING)) != null && placedItemKey.equals(player.getUniqueId().toString())) {
                Debugger.write("BlockPlaceListener: onBlockPlaceEvent cancelled due to broken block.");
                valid = false;
            }
            Debugger.write("BlockPlaceListener: onBlockPlaceEvent broken block check complete.");
        }
        if (valid) {
            Debugger.write("BlockPlaceListener: onBlockPlaceEvent summoned by " + player.getName() + " for " + String.valueOf(block.getType()) + ".");
            this.setPlayerQuestProgression((Event)event, player, 1, "PLACE");
        }
        if (Antiglitch.isStorePlacedBlocks()) {
            Debugger.write("BlockPlaceListener: onBlockPlaceEvent storing placed block.");
            CustomBlockData pdc = new CustomBlockData(block, (Plugin)ODailyQuests.INSTANCE);
            pdc.set(Antiglitch.PLACED_KEY, PersistentDataType.STRING, (Object)block.getType().name());
        }
    }
}

