/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.item;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;

public class SmithItemListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSmithItemEvent(SmithItemEvent event) {
        ClickType click;
        Player player;
        int recipeAmount;
        if (event.isCancelled()) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        ItemStack result = event.getCurrentItem();
        if (this.movingItem(result, recipeAmount = result.getAmount(), player = (Player)event.getWhoClicked(), click = event.getClick())) {
            return;
        }
        switch (click) {
            case NUMBER_KEY: {
                if (event.getWhoClicked().getInventory().getItem(event.getHotbarButton()) == null) break;
                recipeAmount = 0;
                break;
            }
            case DROP: 
            case CONTROL_DROP: {
                ItemStack cursor = event.getCursor();
                if (cursor == null || cursor.getType() == Material.AIR) break;
                recipeAmount = 0;
                break;
            }
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: {
                if (recipeAmount == 0) break;
                int maxCraftable = this.getMaxSmithAmount(event.getInventory());
                int capacity = this.fits(result, player.getInventory().getStorageContents());
                if (capacity < maxCraftable) {
                    maxCraftable = (capacity + recipeAmount - 1) / recipeAmount * recipeAmount;
                }
                recipeAmount = maxCraftable;
                break;
            }
            case SWAP_OFFHAND: {
                boolean haveItemInOffHand = player.getInventory().getItemInOffHand().getType() != Material.AIR;
                recipeAmount = haveItemInOffHand ? 0 : 1;
            }
        }
        if (recipeAmount == 0) {
            return;
        }
        result.setAmount(recipeAmount);
        Debugger.write("SmithItemListener: onSmithItemEvent summoned by " + player.getName() + " for " + String.valueOf(result.getType()) + ".");
        this.setPlayerQuestProgression((Event)event, player, result.getAmount(), "CRAFT");
    }

    private int getMaxSmithAmount(SmithingInventory inv) {
        if (inv.getResult() == null) {
            return 0;
        }
        int resultCount = inv.getResult().getAmount();
        int materialCount = Integer.MAX_VALUE;
        for (ItemStack is : inv.getContents()) {
            if (is == null || is.getAmount() >= materialCount) continue;
            materialCount = is.getAmount();
        }
        return resultCount * materialCount;
    }
}

