/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.files;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.files.implementations.MessagesFile;
import com.ordwen.odailyquests.files.implementations.PlayerInterfaceFile;
import com.ordwen.odailyquests.files.implementations.ProgressionFile;
import com.ordwen.odailyquests.files.implementations.QuestsFiles;
import com.ordwen.odailyquests.files.implementations.TotalRewardsFile;

public class FilesManager {
    private final ODailyQuests plugin;
    private final ConfigurationFile configurationFile;
    private final PlayerInterfaceFile playerInterfaceFile;
    private final TotalRewardsFile totalRewardsFile;
    private final ProgressionFile progressionFile;

    public FilesManager(ODailyQuests plugin) {
        this.plugin = plugin;
        this.configurationFile = new ConfigurationFile(plugin);
        this.playerInterfaceFile = new PlayerInterfaceFile(plugin);
        this.totalRewardsFile = new TotalRewardsFile(plugin);
        this.progressionFile = new ProgressionFile(plugin);
    }

    public void load() {
        this.configurationFile.load();
        this.playerInterfaceFile.load();
        this.totalRewardsFile.load();
        this.progressionFile.load();
        new MessagesFile(this.plugin).load();
        new QuestsFiles(this.plugin).load();
    }

    public ConfigurationFile getConfigurationFile() {
        return this.configurationFile;
    }

    public PlayerInterfaceFile getPlayerInterfaceFile() {
        return this.playerInterfaceFile;
    }

    public TotalRewardsFile getTotalRewardsFile() {
        return this.totalRewardsFile;
    }

    public ProgressionFile getProgressionFile() {
        return this.progressionFile;
    }
}

