/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.files.implementations;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.files.APluginFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesFile
extends APluginFile {
    private static MessagesFile instance;

    public MessagesFile(ODailyQuests plugin) {
        super(plugin);
        instance = this;
    }

    @Override
    public void load() {
        this.file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.file.exists()) {
            this.plugin.saveResource("messages.yml", false);
            PluginLogger.info("Messages file created.");
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            PluginLogger.error("An error occurred while loading the messages file.");
            PluginLogger.error(e.getMessage());
        }
        boolean missingMessages = false;
        for (QuestsMessages item : QuestsMessages.values()) {
            if (this.config.getString(item.getPath()) != null) continue;
            missingMessages = true;
            this.config.set(item.getPath(), (Object)item.getDefault());
        }
        if (missingMessages) {
            try {
                this.config.save(this.file);
            }
            catch (Exception e) {
                PluginLogger.error("An error occurred while saving the messages file.");
                PluginLogger.error(e.getMessage());
            }
            PluginLogger.warn("Some messages are missing in the messages file. Default messages have been added.");
        }
        PluginLogger.fine("Messages file successfully loaded.");
    }

    public String get(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public static MessagesFile getInstance() {
        return instance;
    }
}

