/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.lib.morepaperlib.scheduling;

import com.ordwen.odailyquests.lib.morepaperlib.MorePaperLib;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.AsynchronousScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.AttachedScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.BukkitSchedulerAsAsynchronousScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.BukkitSchedulerAsRegionalScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.EntitySpecificScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.FoliaDetection;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.GlobalAsyncScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.GlobalScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.RegionSpecificScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.RegionalScheduler;
import com.ordwen.odailyquests.lib.morepaperlib.scheduling.StandardFoliaDetection;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class GracefulScheduling {
    private final MorePaperLib morePaperLib;
    private final FoliaDetection foliaDetection;

    public GracefulScheduling(MorePaperLib morePaperLib, FoliaDetection foliaDetection) {
        this.morePaperLib = morePaperLib;
        this.foliaDetection = foliaDetection;
    }

    public GracefulScheduling(MorePaperLib morePaperLib) {
        this(morePaperLib, StandardFoliaDetection.INSTANCE);
    }

    public boolean isUsingFolia() {
        return this.foliaDetection.isUsingFolia();
    }

    public AsynchronousScheduler asyncScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalAsyncScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsAsynchronousScheduler(this.morePaperLib);
    }

    public RegionalScheduler globalRegionalScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    public RegionalScheduler regionSpecificScheduler(Location location) {
        return this.regionSpecificScheduler(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public RegionalScheduler regionSpecificScheduler(World world, int chunkX, int chunkZ) {
        if (this.isUsingFolia()) {
            return new RegionSpecificScheduler(this.morePaperLib.getPlugin(), world, chunkX, chunkZ);
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    public AttachedScheduler entitySpecificScheduler(Entity entity) {
        if (this.isUsingFolia()) {
            return new EntitySpecificScheduler(entity, this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).asAttachedScheduler();
    }

    public boolean isOnGlobalRegionThread() {
        Server server = this.morePaperLib.getPlugin().getServer();
        if (this.isUsingFolia()) {
            return server.isGlobalTickThread();
        }
        return server.isPrimaryThread();
    }

    public void cancelGlobalTasks() {
        if (this.isUsingFolia()) {
            new GlobalAsyncScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            new GlobalScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            return;
        }
        new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).cancelTasks();
    }
}

