/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.categories;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.configuration.essentials.SafetyMode;
import com.ordwen.odailyquests.files.implementations.QuestsFiles;
import com.ordwen.odailyquests.quests.QuestsLoader;
import com.ordwen.odailyquests.quests.categories.Category;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class CategoriesLoader {
    private static final Map<String, Category> categories = new LinkedHashMap<String, Category>();
    private final QuestsLoader questsLoader = new QuestsLoader();

    public void loadCategories() {
        categories.clear();
        boolean safetyMode = SafetyMode.isSafetyModeEnabled();
        for (Map.Entry<String, Integer> entry : QuestsPerCategory.getAllAmounts().entrySet()) {
            String categoryName = entry.getKey();
            int requiredAmount = entry.getValue();
            Category category = new Category(categoryName);
            categories.put(categoryName, category);
            FileConfiguration configFile = QuestsFiles.getQuestsConfigurationByCategory(categoryName);
            if (configFile == null) {
                PluginLogger.error("Failed to load configuration file for " + categoryName + ". Plugin will be disabled.");
                Bukkit.getPluginManager().disablePlugin((Plugin)ODailyQuests.INSTANCE);
                return;
            }
            this.questsLoader.loadQuests(configFile, category, categoryName);
            if (this.validateCategory(category, requiredAmount, categoryName, safetyMode)) continue;
            Bukkit.getPluginManager().disablePlugin((Plugin)ODailyQuests.INSTANCE);
            return;
        }
    }

    private boolean validateCategory(Category category, int requiredAmount, String categoryName, boolean safetyMode) {
        int totalQuests = category.size();
        int publicQuests = (int)category.stream().filter(quest -> {
            List<String> permissions = quest.getRequiredPermissions();
            return (permissions == null || permissions.isEmpty()) && !quest.hasPlaceholderConditions();
        }).count();
        if (totalQuests < requiredAmount) {
            PluginLogger.error("Impossible to enable the plugin.");
            PluginLogger.error("You need at least " + requiredAmount + " quests in your " + categoryName + ".yml file.");
            return false;
        }
        if (safetyMode) {
            if (publicQuests < requiredAmount) {
                PluginLogger.error("Impossible to enable the plugin.");
                PluginLogger.error("Category '" + categoryName + "': only " + publicQuests + " public quest(s) but " + requiredAmount + " required (safety_mode=true).");
                PluginLogger.error("Disable 'safety_mode' if you want permission- or condition-gated categories; note players without the required permissions or placeholders may end up with no quests.");
                return false;
            }
        } else if (publicQuests == 0) {
            PluginLogger.warn("Category '" + categoryName + "' has no public quests. Players without permissions may receive 0 quests (safety_mode=false).");
        }
        return true;
    }

    public static Category getCategoryByName(String name) {
        return categories.get(name);
    }

    public static Map<String, Category> getAllCategories() {
        return categories;
    }

    public static boolean hasCategory(String categoryName) {
        return categories.containsKey(categoryName);
    }
}

