/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.conditions.placeholder;

import com.ordwen.odailyquests.quests.conditions.ConditionOperator;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderConditionResult;
import java.time.Duration;

public final class PlaceholderConditionEvaluator {
    private PlaceholderConditionEvaluator() {
    }

    public static PlaceholderConditionResult evaluate(ConditionOperator type, String placeholderValue, String expectedValue) {
        try {
            boolean equals = placeholderValue.trim().equals(expectedValue.trim());
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ConditionOperator.EQUALS -> PlaceholderConditionResult.of(equals);
                case ConditionOperator.NOT_EQUALS -> PlaceholderConditionResult.of(!equals);
                case ConditionOperator.CONTAINS -> PlaceholderConditionResult.of(placeholderValue.contains(expectedValue));
                case ConditionOperator.NOT_CONTAINS -> PlaceholderConditionResult.of(!placeholderValue.contains(expectedValue));
                case ConditionOperator.STARTS_WITH -> PlaceholderConditionResult.of(placeholderValue.startsWith(expectedValue));
                case ConditionOperator.ENDS_WITH -> PlaceholderConditionResult.of(placeholderValue.endsWith(expectedValue));
                case ConditionOperator.GREATER_THAN, ConditionOperator.GREATER_THAN_OR_EQUALS, ConditionOperator.LESS_THAN, ConditionOperator.LESS_THAN_OR_EQUALS -> PlaceholderConditionEvaluator.evaluateNumeric(type, placeholderValue, expectedValue);
                case ConditionOperator.DURATION_GREATER_THAN, ConditionOperator.DURATION_GREATER_THAN_OR_EQUALS, ConditionOperator.DURATION_LESS_THAN, ConditionOperator.DURATION_LESS_THAN_OR_EQUALS -> PlaceholderConditionEvaluator.evaluateDuration(type, placeholderValue, expectedValue);
            };
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return PlaceholderConditionResult.invalidFormatResult();
        }
    }

    private static PlaceholderConditionResult evaluateNumeric(ConditionOperator type, String placeholderValue, String expectedValue) {
        float current = Float.parseFloat(placeholderValue.replace(",", "."));
        float expected = Float.parseFloat(expectedValue.replace(",", "."));
        return switch (type) {
            case ConditionOperator.GREATER_THAN -> PlaceholderConditionResult.of(current > expected);
            case ConditionOperator.GREATER_THAN_OR_EQUALS -> PlaceholderConditionResult.of(current >= expected);
            case ConditionOperator.LESS_THAN -> PlaceholderConditionResult.of(current < expected);
            case ConditionOperator.LESS_THAN_OR_EQUALS -> PlaceholderConditionResult.of(current <= expected);
            default -> PlaceholderConditionResult.failureResult();
        };
    }

    private static PlaceholderConditionResult evaluateDuration(ConditionOperator type, String placeholderValue, String expectedValue) {
        Duration current = PlaceholderConditionEvaluator.parseDuration(placeholderValue);
        Duration expected = PlaceholderConditionEvaluator.parseDuration(expectedValue);
        return switch (type) {
            case ConditionOperator.DURATION_GREATER_THAN -> PlaceholderConditionResult.of(current.compareTo(expected) > 0);
            case ConditionOperator.DURATION_GREATER_THAN_OR_EQUALS -> PlaceholderConditionResult.of(current.compareTo(expected) >= 0);
            case ConditionOperator.DURATION_LESS_THAN -> PlaceholderConditionResult.of(current.compareTo(expected) < 0);
            case ConditionOperator.DURATION_LESS_THAN_OR_EQUALS -> PlaceholderConditionResult.of(current.compareTo(expected) <= 0);
            default -> PlaceholderConditionResult.failureResult();
        };
    }

    private static Duration parseDuration(String value) {
        String[] parts = value.trim().split(":");
        if (parts.length < 2 || parts.length > 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long h = Long.parseLong(parts[0]);
        long m = Long.parseLong(parts[1]);
        long s = parts.length >= 3 ? Long.parseLong(parts[2]) : 0L;
        long ms = parts.length == 4 ? Long.parseLong(parts[3]) : 0L;
        return Duration.ofHours(h).plusMinutes(m).plusSeconds(s).plusMillis(ms);
    }
}

