/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.conditions.placeholder;

import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderCondition;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderConditionEvaluator;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderConditionResult;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.List;
import org.bukkit.entity.Player;

public final class PlaceholderRuleSetEvaluator {
    private PlaceholderRuleSetEvaluator() {
    }

    public static boolean evaluate(Player player, List<PlaceholderCondition> conditions, boolean sendMessages) {
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        if (!PlaceholderRuleSetEvaluator.isPlaceholderApiReady(player, sendMessages)) {
            return false;
        }
        for (PlaceholderCondition condition : conditions) {
            String placeholderValue = TextFormatter.format(player, condition.placeholder());
            String expectedValue = TextFormatter.format(player, condition.expectedValue());
            PlaceholderConditionResult result = PlaceholderConditionEvaluator.evaluate(condition.conditionOperator(), placeholderValue, expectedValue);
            if (result.invalidFormat()) {
                return PlaceholderRuleSetEvaluator.handleInvalidFormat(player, sendMessages, placeholderValue);
            }
            if (result.matched()) continue;
            return PlaceholderRuleSetEvaluator.handleMismatch(player, sendMessages, condition);
        }
        return true;
    }

    private static boolean isPlaceholderApiReady(Player player, boolean sendMessages) {
        if (TextFormatter.isPlaceholderAPIEnabled()) {
            return true;
        }
        if (sendMessages) {
            PlaceholderRuleSetEvaluator.sendMessage(player, QuestsMessages.PLACEHOLDER_API_NOT_ENABLED.getMessage(player));
        }
        return false;
    }

    private static boolean handleInvalidFormat(Player player, boolean sendMessages, String placeholderValue) {
        String template;
        if (sendMessages && (template = QuestsMessages.PLACEHOLDER_NOT_NUMBER.toString()) != null) {
            player.sendMessage(template.replace("%placeholder%", placeholderValue));
        }
        return false;
    }

    private static boolean handleMismatch(Player player, boolean sendMessages, PlaceholderCondition condition) {
        String rawMessage;
        if (sendMessages && (rawMessage = condition.errorMessage()) != null && !rawMessage.isEmpty()) {
            PlaceholderRuleSetEvaluator.sendMessage(player, TextFormatter.format(player, rawMessage));
        }
        return false;
    }

    private static void sendMessage(Player player, String message) {
        if (message != null && !message.isEmpty()) {
            player.sendMessage(message);
        }
    }
}

