/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.api.events.AllCategoryQuestsCompletedEvent;
import com.ordwen.odailyquests.api.events.AllQuestsCompletedEvent;
import com.ordwen.odailyquests.api.events.CategoryTotalRewardReachedEvent;
import com.ordwen.odailyquests.api.events.TotalRewardReachedEvent;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.configuration.essentials.RerollNotAchieved;
import com.ordwen.odailyquests.configuration.functionalities.rewards.TotalRewards;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.categories.Category;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerQuests {
    private final Long timestamp;
    private int achievedQuests;
    private int totalAchievedQuests;
    private final Map<AbstractQuest, Progression> quests;
    private final Map<String, Integer> achievedQuestsByCategory = new HashMap<String, Integer>();
    private final Map<String, Integer> totalAchievedQuestsByCategory = new HashMap<String, Integer>();

    public PlayerQuests(Long timestamp, Map<AbstractQuest, Progression> quests) {
        this.timestamp = timestamp;
        this.quests = quests;
        this.achievedQuests = 0;
        this.totalAchievedQuests = 0;
        this.setAchievedQuestsByCategory();
    }

    private void setAchievedQuestsByCategory() {
        for (Map.Entry<AbstractQuest, Progression> entry : this.quests.entrySet()) {
            if (!entry.getValue().isAchieved()) continue;
            String category = entry.getKey().getCategoryName();
            if (this.achievedQuestsByCategory.containsKey(category)) {
                this.achievedQuestsByCategory.put(category, this.achievedQuestsByCategory.get(category) + 1);
                continue;
            }
            this.achievedQuestsByCategory.put(category, 1);
        }
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void increaseCategoryAchievedQuests(String category, Player player) {
        Event event;
        Debugger.write("PlayerQuests: increaseAchievedQuests summoned by " + player.getName() + " for category " + category + ".");
        ++this.achievedQuests;
        ++this.totalAchievedQuests;
        if (this.achievedQuestsByCategory.containsKey(category)) {
            this.achievedQuestsByCategory.put(category, this.achievedQuestsByCategory.get(category) + 1);
        } else {
            this.achievedQuestsByCategory.put(category, 1);
        }
        if (this.totalAchievedQuestsByCategory.containsKey(category)) {
            this.totalAchievedQuestsByCategory.put(category, this.totalAchievedQuestsByCategory.get(category) + 1);
        } else {
            this.totalAchievedQuestsByCategory.put(category, 1);
        }
        Debugger.write("PlayerQuests: increaseAchievedQuests: " + player.getName() + " has completed " + String.valueOf(this.achievedQuestsByCategory.get(category)) + " quests in category " + category + ".");
        if (this.achievedQuestsByCategory.get(category) == QuestsPerCategory.getAmountForCategory(category)) {
            Debugger.write("PlayerQuests: AllCategoryQuestsCompletedEvent is called.");
            event = new AllCategoryQuestsCompletedEvent(player, category);
            ODailyQuests.INSTANCE.getServer().getPluginManager().callEvent(event);
        }
        if (this.achievedQuests == QuestsPerCategory.getTotalQuestsAmount()) {
            Debugger.write("PlayerQuests: AllQuestsCompletedEvent is called.");
            event = new AllQuestsCompletedEvent(player);
            ODailyQuests.INSTANCE.getServer().getPluginManager().callEvent(event);
        }
        if (TotalRewards.isGlobalStep(this.totalAchievedQuests)) {
            Debugger.write("PlayerQuests: TotalRewardReachedEvent is called for " + player.getName() + " with total achieved quests: " + this.totalAchievedQuests + ".");
            event = new TotalRewardReachedEvent(player, this.totalAchievedQuests);
            ODailyQuests.INSTANCE.getServer().getPluginManager().callEvent(event);
        }
        if (TotalRewards.isCategoryStep(category, this.totalAchievedQuestsByCategory.get(category))) {
            Debugger.write("PlayerQuests: CategoryTotalRewardReachedEvent is called for " + player.getName() + " in category " + category + " with total achieved quests: " + String.valueOf(this.totalAchievedQuestsByCategory.get(category)) + ".");
            event = new CategoryTotalRewardReachedEvent(player, category, this.totalAchievedQuestsByCategory.get(category));
            ODailyQuests.INSTANCE.getServer().getPluginManager().callEvent(event);
        }
    }

    public boolean rerollQuest(int index, Player player) {
        ArrayList<AbstractQuest> oldQuests = new ArrayList<AbstractQuest>(this.quests.keySet());
        AbstractQuest questToRemove = (AbstractQuest)oldQuests.get(index);
        Progression progressionToRemove = this.quests.get(questToRemove);
        if (!this.isRerollAllowed(progressionToRemove, player)) {
            return false;
        }
        String categoryName = questToRemove.getCategoryName();
        Category category = CategoriesLoader.getCategoryByName(categoryName);
        if (category == null) {
            this.logCategoryNullError();
            return false;
        }
        HashSet<AbstractQuest> currentWithoutRemoved = new HashSet<AbstractQuest>(this.quests.keySet());
        currentWithoutRemoved.remove(questToRemove);
        AbstractQuest newQuest = QuestsManager.getRandomQuestForPlayer(currentWithoutRemoved, category, player);
        if (newQuest == null) {
            this.notifyNoAvailableQuests(player, categoryName);
            return false;
        }
        LinkedHashMap<AbstractQuest, Progression> newPlayerQuests = this.rebuildQuestsMap(oldQuests, questToRemove, newQuest);
        this.quests.clear();
        this.quests.putAll(newPlayerQuests);
        this.updateAchievementsAfterRerollIfNeeded(progressionToRemove, categoryName, questToRemove);
        return true;
    }

    private boolean isRerollAllowed(Progression progression, Player player) {
        if (progression.isAchieved() && RerollNotAchieved.isRerollIfNotAchieved()) {
            String msg = QuestsMessages.CANNOT_REROLL_IF_ACHIEVED.toString();
            if (msg != null) {
                player.sendMessage(msg);
            }
            return false;
        }
        return true;
    }

    private void logCategoryNullError() {
        PluginLogger.error("An error occurred while rerolling a quest. The category is null.");
        PluginLogger.error("If the problem persists, please contact the developer.");
    }

    private void notifyNoAvailableQuests(Player player, String categoryName) {
        String msg = QuestsMessages.NO_AVAILABLE_QUESTS_IN_CATEGORY.toString();
        if (msg != null) {
            player.sendMessage(msg.replace("%category%", categoryName));
        }
    }

    private LinkedHashMap<AbstractQuest, Progression> rebuildQuestsMap(List<AbstractQuest> oldQuests, AbstractQuest questToRemove, AbstractQuest newQuest) {
        LinkedHashMap<AbstractQuest, Progression> map = new LinkedHashMap<AbstractQuest, Progression>();
        for (AbstractQuest quest : oldQuests) {
            if (quest.equals(questToRemove)) {
                map.put(newQuest, QuestsManager.createFreshProgression(newQuest));
                continue;
            }
            map.put(quest, this.quests.get(quest));
        }
        return map;
    }

    private void updateAchievementsAfterRerollIfNeeded(Progression removedProgression, String categoryName, AbstractQuest questToRemove) {
        if (!removedProgression.isAchieved()) {
            return;
        }
        this.decreaseAchievedQuests();
        int achievedByCategory = this.achievedQuestsByCategory.get(categoryName);
        int totalForCategory = QuestsPerCategory.getAmountForCategory(categoryName);
        if (achievedByCategory >= totalForCategory) {
            Debugger.write("All quests from category " + categoryName + " have been completed. Nothing to do.");
            return;
        }
        this.achievedQuestsByCategory.put(questToRemove.getCategoryName(), achievedByCategory - 1);
        Debugger.write("Quest removed from category " + categoryName + ". Quests completed: " + (achievedByCategory - 1) + "/" + totalForCategory + ".");
    }

    public ReplaceResult setQuestAtIndex(int index, AbstractQuest newQuest) {
        ArrayList<AbstractQuest> orderedQuests = new ArrayList<AbstractQuest>(this.quests.keySet());
        if (this.quests.containsKey(newQuest)) {
            return ReplaceResult.ALREADY_PRESENT;
        }
        if (index < 0 || index >= orderedQuests.size()) {
            return ReplaceResult.INVALID_INDEX;
        }
        AbstractQuest questToReplace = (AbstractQuest)orderedQuests.get(index);
        Progression oldProgression = this.quests.get(questToReplace);
        LinkedHashMap<AbstractQuest, Progression> updatedQuests = new LinkedHashMap<AbstractQuest, Progression>();
        for (int i = 0; i < orderedQuests.size(); ++i) {
            AbstractQuest quest = (AbstractQuest)orderedQuests.get(i);
            if (i == index) {
                updatedQuests.put(newQuest, QuestsManager.createFreshProgression(newQuest));
                continue;
            }
            updatedQuests.put(quest, this.quests.get(quest));
        }
        this.quests.clear();
        this.quests.putAll(updatedQuests);
        if (oldProgression != null && oldProgression.isAchieved()) {
            this.decreaseAchievedQuests();
            String oldCategory = questToReplace.getCategoryName();
            int achievedByCategory = this.achievedQuestsByCategory.getOrDefault(oldCategory, 0);
            if (achievedByCategory > 0) {
                this.achievedQuestsByCategory.put(oldCategory, achievedByCategory - 1);
            }
        }
        return ReplaceResult.SUCCESS;
    }

    public void decreaseAchievedQuests() {
        --this.achievedQuests;
    }

    public void setAchievedQuests(int i) {
        this.achievedQuests = i;
    }

    public void setTotalAchievedQuests(int i) {
        this.totalAchievedQuests = i;
    }

    public void setTotalCategoryAchievedQuests(String category, int i) {
        this.totalAchievedQuestsByCategory.put(category, i);
    }

    public void setTotalAchievedQuestsByCategory(Map<String, Integer> totals) {
        this.totalAchievedQuestsByCategory.clear();
        this.totalAchievedQuestsByCategory.putAll(totals);
    }

    public void addTotalAchievedQuests(int i) {
        this.totalAchievedQuests += i;
    }

    public void addTotalCategoryAchievedQuests(String category, int amount) {
        if (this.totalAchievedQuestsByCategory.containsKey(category)) {
            int newAmount = this.totalAchievedQuestsByCategory.get(category) + amount;
            this.totalAchievedQuestsByCategory.put(category, newAmount);
        } else {
            this.totalAchievedQuestsByCategory.put(category, amount);
        }
    }

    public void removeTotalAchievedQuests(int i) {
        this.totalAchievedQuests = Math.max(this.totalAchievedQuests - i, 0);
    }

    public void removeTotalCategoryAchievedQuests(String category, int amount) {
        if (this.totalAchievedQuestsByCategory.containsKey(category)) {
            int toSet = Math.max(this.totalAchievedQuestsByCategory.get(category) - amount, 0);
            this.totalAchievedQuestsByCategory.put(category, toSet);
        } else {
            this.totalAchievedQuestsByCategory.put(category, 0);
        }
    }

    public int getAchievedQuests() {
        return this.achievedQuests;
    }

    public int getTotalAchievedQuests() {
        return this.totalAchievedQuests;
    }

    public Map<AbstractQuest, Progression> getQuests() {
        return this.quests;
    }

    public Map<String, Integer> getTotalAchievedQuestsByCategory() {
        return this.totalAchievedQuestsByCategory;
    }

    public int getTotalAchievedQuestsByCategory(String category) {
        return this.totalAchievedQuestsByCategory.getOrDefault(category, 0);
    }

    public static enum ReplaceResult {
        SUCCESS,
        INVALID_INDEX,
        ALREADY_PRESENT;

    }
}

