/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.categories.Category;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderRuleSetEvaluator;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.EntityQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class QuestsManager
implements Listener {
    private static final Random random = new Random();
    private final ODailyQuests plugin;
    private static final Map<String, PlayerQuests> activeQuests = new HashMap<String, PlayerQuests>();

    public QuestsManager(ODailyQuests oDailyQuests) {
        this.plugin = oDailyQuests;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Debugger.write("[EVENT START]");
        Debugger.write("PlayerJoinEvent triggered.");
        Player player = event.getPlayer();
        String playerName = player.getName();
        UUID uuid = player.getUniqueId();
        Debugger.write("Player " + playerName + " joined the server.");
        Debugger.write("Player UUID is " + String.valueOf(uuid));
        if (!activeQuests.containsKey(playerName)) {
            Debugger.write("Player " + playerName + " is not in the array.");
            this.plugin.getDatabaseManager().loadQuestsForPlayer(playerName);
        } else {
            Debugger.write("Player " + playerName + " is already in the array.");
            PluginLogger.warn(playerName + " detected into the array. This is not supposed to happen!");
            PluginLogger.warn("If the player can't make his quests progress, please contact the plugin developer.");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Debugger.write("[EVENT START]");
        Debugger.write("PlayerQuitEvent triggered.");
        Player player = event.getPlayer();
        String playerName = player.getName();
        String playerUUID = player.getUniqueId().toString();
        Debugger.write("Player " + playerName + " left the server.");
        PlayerQuests playerQuests = activeQuests.get(playerName);
        if (playerQuests == null) {
            Debugger.write("Player " + playerName + " not found in the array.");
            PluginLogger.warn("Player quests not found for player " + playerName);
            return;
        }
        this.plugin.getDatabaseManager().saveProgressionForPlayer(playerName, playerUUID, playerQuests);
        activeQuests.remove(playerName);
        Debugger.write("Player " + playerName + " removed from the array.");
    }

    public static Map<AbstractQuest, Progression> selectRandomQuests(Player player) {
        LinkedHashMap<AbstractQuest, Progression> quests = new LinkedHashMap<AbstractQuest, Progression>();
        Map<String, Category> categoryMap = CategoriesLoader.getAllCategories();
        block0: for (Map.Entry<String, Category> entry : categoryMap.entrySet()) {
            String categoryName = entry.getKey();
            Category category = entry.getValue();
            int requiredAmount = QuestsPerCategory.getAmountForCategory(categoryName);
            for (int i = 0; i < requiredAmount; ++i) {
                AbstractQuest quest = QuestsManager.getRandomQuestForPlayer(quests.keySet(), category, player);
                if (quest == null) {
                    PluginLogger.warn("Not enough quests available to assign to " + player.getName() + " in category " + categoryName + ".");
                    continue block0;
                }
                Progression progression = QuestsManager.createFreshProgression(quest);
                quests.put(quest, progression);
            }
        }
        return quests;
    }

    public static int getDynamicRequiredAmount(String requiredAmountRaw) {
        if (requiredAmountRaw.contains("-")) {
            String[] parts = requiredAmountRaw.split("-");
            int min = Integer.parseInt(parts[0].trim());
            int max = Integer.parseInt(parts[1].trim());
            if (min < 1) {
                min = 1;
            }
            return random.nextInt(min, max + 1);
        }
        int amount = Integer.parseInt(requiredAmountRaw);
        return Math.max(amount, 1);
    }

    private static int getRandomIndexFrom(AbstractQuest quest) {
        if (quest instanceof EntityQuest) {
            EntityQuest eq = (EntityQuest)quest;
            return random.nextInt(eq.getRequiredEntities().size());
        }
        if (quest instanceof ItemQuest) {
            ItemQuest iq = (ItemQuest)quest;
            return random.nextInt(iq.getRequiredItems().size());
        }
        return 0;
    }

    public static Progression createFreshProgression(AbstractQuest quest) {
        int requiredAmount = QuestsManager.getDynamicRequiredAmount(quest.getRequiredAmountRaw());
        Progression progression = new Progression(requiredAmount, 0, false);
        if (quest.isRandomRequired()) {
            progression.setSelectedRequiredIndex(QuestsManager.getRandomIndexFrom(quest));
        }
        return progression;
    }

    public static AbstractQuest getRandomQuestForPlayer(Set<AbstractQuest> currentQuests, List<AbstractQuest> availableQuests, Player player) {
        ArrayList<AbstractQuest> filteredQuests = new ArrayList<AbstractQuest>();
        for (AbstractQuest quest : availableQuests) {
            if (!QuestsManager.hasAllPermissions(player, quest.getRequiredPermissions()) || currentQuests.contains(quest) || !PlaceholderRuleSetEvaluator.evaluate(player, quest.getPlaceholderConditions(), false)) continue;
            filteredQuests.add(quest);
        }
        if (filteredQuests.isEmpty()) {
            return null;
        }
        int randomIndex = random.nextInt(filteredQuests.size());
        return (AbstractQuest)filteredQuests.get(randomIndex);
    }

    private static boolean hasAllPermissions(Player player, List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return true;
        }
        for (String permission : permissions) {
            if (player.hasPermission(permission)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, PlayerQuests> getActiveQuests() {
        return activeQuests;
    }
}

