/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.configuration.functionalities.CompleteOnlyOnClick;
import com.ordwen.odailyquests.configuration.functionalities.DisabledWorlds;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import com.ordwen.odailyquests.quests.player.progression.clickable.commands.GetQuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.commands.LocationQuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.commands.ManualCompletionQuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.commands.PlaceholderQuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.commands.VillagerTradeQuestCommand;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.inventory.GetQuest;
import com.ordwen.odailyquests.quests.types.inventory.LocationQuest;
import com.ordwen.odailyquests.quests.types.inventory.PlaceholderQuest;
import com.ordwen.odailyquests.quests.types.item.VillagerQuest;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ClickableChecker
extends PlayerProgressor {
    public void processQuestCompletion(QuestContext context) {
        Player player = context.getPlayer();
        ItemStack clickedItem = context.getClickedItem();
        Villager villager = context.getVillager();
        if (this.isWorldDisabled(player)) {
            return;
        }
        Map<AbstractQuest, Progression> playerQuests = ODailyQuestsAPI.getPlayerQuests(player.getName()).getQuests();
        for (Map.Entry<AbstractQuest, Progression> entry : playerQuests.entrySet()) {
            QuestCommand<? extends AbstractQuest> command;
            AbstractQuest abstractQuest = entry.getKey();
            Progression progression = entry.getValue();
            if (progression.isAchieved() || (command = this.createCommandForQuest(abstractQuest, progression, context, clickedItem, villager)) == null) continue;
            command.execute();
        }
    }

    private boolean isWorldDisabled(Player player) {
        if (DisabledWorlds.isWorldDisabled(player.getWorld().getName())) {
            String msg = QuestsMessages.WORLD_DISABLED.getMessage(player);
            if (msg != null) {
                player.sendMessage(msg);
            }
            return true;
        }
        return false;
    }

    private QuestCommand<? extends AbstractQuest> createCommandForQuest(AbstractQuest abstractQuest, Progression progression, QuestContext context, ItemStack clickedItem, Villager villager) {
        if (abstractQuest instanceof GetQuest) {
            GetQuest getQuest = (GetQuest)abstractQuest;
            return this.createGetQuestCommand(getQuest, clickedItem, context, progression);
        }
        if (abstractQuest instanceof LocationQuest) {
            LocationQuest locationQuest = (LocationQuest)abstractQuest;
            return this.createLocationQuestCommand(locationQuest, clickedItem, context, progression);
        }
        if (abstractQuest instanceof PlaceholderQuest) {
            PlaceholderQuest placeholderQuest = (PlaceholderQuest)abstractQuest;
            return this.createPlaceholderQuestCommand(placeholderQuest, clickedItem, context, progression);
        }
        if (abstractQuest instanceof VillagerQuest) {
            VillagerQuest villagerQuest = (VillagerQuest)abstractQuest;
            if (villager != null && villagerQuest.getQuestType().equals("VILLAGER_TRADE")) {
                return new VillagerTradeQuestCommand(context, progression, villagerQuest);
            }
        }
        if (CompleteOnlyOnClick.isEnabled() && this.isManualCompletionEligible(abstractQuest, progression, clickedItem)) {
            return new ManualCompletionQuestCommand(context, progression, abstractQuest);
        }
        return null;
    }

    private boolean isManualCompletionEligible(AbstractQuest quest, Progression progression, ItemStack clickedItem) {
        if (progression.getAdvancement() < progression.getRequiredAmount()) {
            return false;
        }
        return this.isAppropriateQuestMenuItem(clickedItem, quest.getMenuItem());
    }

    private QuestCommand<GetQuest> createGetQuestCommand(GetQuest quest, ItemStack clickedItem, QuestContext context, Progression progression) {
        if (this.isAppropriateQuestMenuItem(clickedItem, quest.getMenuItem()) && quest.getQuestType().equals("GET")) {
            return new GetQuestCommand(context, progression, quest);
        }
        return null;
    }

    private QuestCommand<LocationQuest> createLocationQuestCommand(LocationQuest quest, ItemStack clickedItem, QuestContext context, Progression progression) {
        if (this.isAppropriateQuestMenuItem(clickedItem, quest.getMenuItem()) && quest.getQuestType().equals("LOCATION")) {
            return new LocationQuestCommand(context, progression, quest);
        }
        return null;
    }

    private QuestCommand<PlaceholderQuest> createPlaceholderQuestCommand(PlaceholderQuest quest, ItemStack clickedItem, QuestContext context, Progression progression) {
        if (this.isAppropriateQuestMenuItem(clickedItem, quest.getMenuItem()) && quest.getQuestType().equals("PLACEHOLDER")) {
            return new PlaceholderQuestCommand(context, progression, quest);
        }
        return null;
    }

    private boolean isAppropriateQuestMenuItem(ItemStack clickedItem, ItemStack menuItem) {
        if (clickedItem == null || menuItem == null) {
            return false;
        }
        ItemMeta clickedItemMeta = clickedItem.getItemMeta();
        ItemMeta menuItemMeta = menuItem.getItemMeta();
        if (clickedItem.getType() != menuItem.getType()) {
            return false;
        }
        if (clickedItemMeta == null || menuItemMeta == null) {
            return false;
        }
        return clickedItemMeta.getPersistentDataContainer().equals((Object)menuItemMeta.getPersistentDataContainer());
    }
}

