/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable.commands;

import com.ordwen.odailyquests.configuration.functionalities.TakeItem;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import com.ordwen.odailyquests.quests.types.inventory.GetQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import java.util.HashMap;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class GetQuestCommand
extends QuestCommand<GetQuest> {
    public GetQuestCommand(QuestContext context, Progression progression, GetQuest quest) {
        super(context, progression, quest);
    }

    @Override
    public void execute() {
        if (!((GetQuest)this.quest).isAllowedToProgress(this.context.getPlayer(), this.quest)) {
            return;
        }
        PlayerInventory inventory = this.context.getPlayer().getInventory();
        int totalAmount = this.calculateTotalAmount(inventory, (ItemQuest)this.quest);
        if (totalAmount == -1) {
            this.sendMessage(QuestsMessages.CANNOT_COMPLETE_QUEST_WITH_OFF_HAND);
            return;
        }
        if (totalAmount >= this.progression.getRequiredAmount()) {
            boolean success;
            if (TakeItem.isTakeItemsEnabled() && !(success = this.removeRequiredItems(inventory, (ItemQuest)this.quest, this.progression.getRequiredAmount()))) {
                this.sendMessage(QuestsMessages.NOT_ENOUGH_ITEM);
                return;
            }
            this.completeQuest();
        } else {
            this.sendMessage(QuestsMessages.NOT_ENOUGH_ITEM);
        }
    }

    private int calculateTotalAmount(PlayerInventory inventory, ItemQuest quest) {
        int totalAmount = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !quest.isRequiredItem(item, this.progression)) continue;
            if (inventory.getItemInOffHand().equals((Object)item)) {
                return -1;
            }
            totalAmount += item.getAmount();
        }
        return totalAmount;
    }

    private boolean removeRequiredItems(PlayerInventory inventory, ItemQuest quest, int amountToRemove) {
        HashMap<Integer, ItemStack> backup = new HashMap<Integer, ItemStack>();
        int removedAmount = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || !quest.isRequiredItem(item, this.progression)) continue;
            int removable = Math.min(item.getAmount(), amountToRemove - removedAmount);
            backup.put(i, item.clone());
            if (removable == item.getAmount()) {
                inventory.setItem(i, null);
            } else {
                item.setAmount(item.getAmount() - removable);
            }
            if ((removedAmount += removable) >= amountToRemove) break;
        }
        if (removedAmount < amountToRemove) {
            backup.forEach((arg_0, arg_1) -> ((PlayerInventory)inventory).setItem(arg_0, arg_1));
            return false;
        }
        return true;
    }
}

