/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable.commands;

import com.ordwen.odailyquests.api.events.QuestCompletedEvent;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import com.ordwen.odailyquests.quests.types.inventory.LocationQuest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class LocationQuestCommand
extends QuestCommand<LocationQuest> {
    public LocationQuestCommand(QuestContext context, Progression progression, LocationQuest quest) {
        super(context, progression, quest);
    }

    @Override
    public void execute() {
        Player player = this.context.getPlayer();
        if (!((LocationQuest)this.quest).isAllowedToProgress(player, this.quest)) {
            return;
        }
        Location requiredLocation = ((LocationQuest)this.quest).getRequiredLocation();
        World requiredWorld = requiredLocation.getWorld();
        if (requiredWorld != null && !requiredWorld.equals((Object)player.getLocation().getWorld())) {
            this.sendMessage(QuestsMessages.BAD_WORLD_LOCATION);
            return;
        }
        double distance = player.getLocation().distance(requiredLocation);
        if (distance <= (double)((LocationQuest)this.quest).getRadius()) {
            QuestCompletedEvent event = new QuestCompletedEvent(player, this.progression, this.quest);
            Bukkit.getPluginManager().callEvent((Event)event);
            player.closeInventory();
        } else {
            this.sendMessage(QuestsMessages.TOO_FAR_FROM_LOCATION);
        }
    }
}

