/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable.commands;

import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderConditionEvaluator;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderConditionResult;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import com.ordwen.odailyquests.quests.types.inventory.PlaceholderQuest;
import com.ordwen.odailyquests.tools.TextFormatter;
import org.bukkit.entity.Player;

public class PlaceholderQuestCommand
extends QuestCommand<PlaceholderQuest> {
    public PlaceholderQuestCommand(QuestContext context, Progression progression, PlaceholderQuest quest) {
        super(context, progression, quest);
    }

    @Override
    public void execute() {
        Player player = this.context.getPlayer();
        if (!((PlaceholderQuest)this.quest).isAllowedToProgress(player, this.quest)) {
            return;
        }
        if (!TextFormatter.isPlaceholderAPIEnabled()) {
            this.sendMessage(QuestsMessages.PLACEHOLDER_API_NOT_ENABLED);
            return;
        }
        String placeholderValue = TextFormatter.format(player, ((PlaceholderQuest)this.quest).getPlaceholder());
        String expectedValue = TextFormatter.format(player, ((PlaceholderQuest)this.quest).getExpectedValue());
        PlaceholderConditionResult result = PlaceholderConditionEvaluator.evaluate(((PlaceholderQuest)this.quest).getConditionType(), placeholderValue, expectedValue);
        if (result.invalidFormat()) {
            this.handleValidationError(placeholderValue);
            return;
        }
        if (result.matched()) {
            this.completeQuest();
        } else {
            String message = TextFormatter.format(player, ((PlaceholderQuest)this.quest).getErrorMessage());
            if (message != null && !message.isEmpty()) {
                player.sendMessage(message);
            }
        }
    }

    private void handleValidationError(String placeholder) {
        String message = QuestsMessages.PLACEHOLDER_NOT_NUMBER.toString();
        if (message != null) {
            message = message.replace("%placeholder%", placeholder);
            this.context.getPlayer().sendMessage(message);
        }
    }
}

