/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable.commands;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.events.antiglitch.OpenedRecipes;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestCommand;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import com.ordwen.odailyquests.quests.types.item.VillagerQuest;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class VillagerTradeQuestCommand
extends QuestCommand<VillagerQuest> {
    public VillagerTradeQuestCommand(QuestContext context, Progression progression, VillagerQuest quest) {
        super(context, progression, quest);
    }

    @Override
    public void execute() {
        Debugger.write("Executing VillagerTradeQuestCommand for quest: " + ((VillagerQuest)this.quest).getQuestName());
        if (!((VillagerQuest)this.quest).isAllowedToProgress(this.context.getPlayer(), this.quest)) {
            Debugger.write("Player " + this.context.getPlayer().getName() + " is not allowed to progress the quest: " + ((VillagerQuest)this.quest).getQuestName());
            return;
        }
        MerchantRecipe selectedRecipe = this.context.getSelectedRecipe();
        if (selectedRecipe == null) {
            Debugger.write("No selected recipe for villager trade quest: " + ((VillagerQuest)this.quest).getQuestName());
            return;
        }
        if (!this.isValidTrade(selectedRecipe)) {
            Debugger.write(String.valueOf(selectedRecipe) + " is not a valid villager trade quest");
            return;
        }
        Villager villager = this.context.getVillager();
        if (villager != null && !this.isValidVillager(villager)) {
            Debugger.write("Villager " + villager.getName() + " does not match the quest requirements for profession or level.");
            return;
        }
        Debugger.write("Villager trade quest is valid for player: " + this.context.getPlayer().getName() + ", proceeding with quest action.");
        ((VillagerQuest)this.quest).actionQuest(this.context.getPlayer(), this.progression, this.quest, this.context.getQuantity());
    }

    private boolean isValidTrade(MerchantRecipe selectedRecipe) {
        if (!((VillagerQuest)this.quest).getRequiredItems().isEmpty() && !this.isValidRequiredItem(selectedRecipe)) {
            return false;
        }
        return selectedRecipe.getUses() > OpenedRecipes.get(selectedRecipe);
    }

    private boolean isValidRequiredItem(MerchantRecipe selectedRecipe) {
        for (ItemStack item : ((VillagerQuest)this.quest).getRequiredItems()) {
            if (item.getType() != selectedRecipe.getResult().getType()) continue;
            return true;
        }
        return false;
    }

    private boolean isValidVillager(Villager villager) {
        return this.isValidProfession(villager) && this.isValidLevel(villager);
    }

    private boolean isValidProfession(Villager villager) {
        return ((VillagerQuest)this.quest).getVillagerProfession() == null || ((VillagerQuest)this.quest).getVillagerProfession().equals((Object)villager.getProfession());
    }

    private boolean isValidLevel(Villager villager) {
        return ((VillagerQuest)this.quest).getVillagerLevel() == 0 || ((VillagerQuest)this.quest).getVillagerLevel() == villager.getVillagerLevel();
    }
}

