/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.custom.mobs;

import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public abstract class CustomMobQuest
extends AbstractQuest {
    private static final String NAME_PATH = ".entity_name";
    protected List<String> entityNames = new ArrayList<String>();

    protected CustomMobQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        if (section.isString(NAME_PATH)) {
            this.entityNames.add(section.getString(NAME_PATH));
        } else {
            this.entityNames.addAll(section.getStringList(NAME_PATH));
        }
        for (String entityName : this.entityNames) {
            this.entityNames.set(this.entityNames.indexOf(entityName), TextFormatter.format(entityName));
        }
        if (this.entityNames.isEmpty()) {
            PluginLogger.configurationError(file, index, null, "There is no entity name defined for quest type CUSTOM_MOBS.");
            return false;
        }
        return true;
    }

    public boolean isRequiredEntity(String entityName) {
        return this.entityNames.contains(entityName);
    }
}

