/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.inventory;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LocationQuest
extends AbstractQuest {
    private static final String LOCATION_PATH = ".location";
    Location requiredLocation;
    int radius;

    public LocationQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "LOCATION";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        return false;
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        ConfigurationSection locationSection = section.getConfigurationSection(LOCATION_PATH);
        if (locationSection == null) {
            PluginLogger.configurationError(file, index, LOCATION_PATH, "You need to specify a location.");
            return false;
        }
        if (!locationSection.contains(".radius")) {
            PluginLogger.configurationError(file, index, "radius", "You need to specify a radius.");
            return false;
        }
        this.radius = locationSection.getInt(".radius");
        String wd = locationSection.getString(".world");
        if (wd == null) {
            PluginLogger.configurationError(file, index, "world", "You need to specify a world.");
            return false;
        }
        World world = Bukkit.getWorld((String)wd);
        if (world == null) {
            PluginLogger.configurationError(file, index, "world", "The world specified in the location is invalid.");
            return false;
        }
        int x = locationSection.getInt(".x");
        int y = locationSection.getInt(".y");
        int z = locationSection.getInt(".z");
        this.requiredLocation = new Location(world, (double)x, (double)y, (double)z);
        ItemStack menuItem = super.getMenuItem();
        ItemMeta meta = menuItem.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "quest_type"), PersistentDataType.STRING, (Object)LOCATION_PATH);
        container.set(new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "quest_index"), PersistentDataType.STRING, (Object)index);
        container.set(new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "file_name"), PersistentDataType.STRING, (Object)file);
        menuItem.setItemMeta(meta);
        return true;
    }

    public Location getRequiredLocation() {
        return this.requiredLocation;
    }

    public int getRadius() {
        return this.radius;
    }
}

