/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.item;

import com.nexomc.nexo.api.NexoItems;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.integrations.ItemsAdderEnabled;
import com.ordwen.odailyquests.configuration.integrations.NexoEnabled;
import com.ordwen.odailyquests.configuration.integrations.OraxenEnabled;
import com.ordwen.odailyquests.externs.hooks.Protection;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import com.ordwen.odailyquests.tools.PluginUtils;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.Events.CustomBlockBreakEvent;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import net.momirealms.customcrops.api.event.CropBreakEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BreakQuest
extends ItemQuest {
    public BreakQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "BREAK";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        if (provided instanceof BlockBreakEvent) {
            Material material;
            BlockBreakEvent event = (BlockBreakEvent)provided;
            if (event.isCancelled()) {
                return false;
            }
            Block block = event.getBlock();
            if (!this.isProtectionBypass() && !Protection.canBuild(event.getPlayer(), block, "BLOCK_BREAK")) {
                return false;
            }
            Debugger.write("BlockBreakListener: onBlockBreakEvent summoned by " + event.getPlayer().getName() + " for " + String.valueOf(block.getType()) + ".");
            switch (block.getType()) {
                case POTATOES: {
                    Material material2 = Material.POTATO;
                    break;
                }
                case CARROTS: {
                    Material material2 = Material.CARROT;
                    break;
                }
                case BEETROOTS: {
                    Material material2 = Material.BEETROOT;
                    break;
                }
                case COCOA: {
                    Material material2 = Material.COCOA_BEANS;
                    break;
                }
                case SWEET_BERRY_BUSH: {
                    Material material2 = Material.SWEET_BERRIES;
                    break;
                }
                default: {
                    Material material2 = material = block.getType();
                }
            }
            if (!material.isItem()) {
                Debugger.write("BreakQuest: canProgress material is not an item: " + String.valueOf(material));
                Debugger.write("BreakQuest: cancelling event.");
                return false;
            }
            Debugger.write("BreakQuest: canProgress material: " + String.valueOf(material));
            return super.isRequiredItem(new ItemStack(material), progression);
        }
        if (PluginUtils.isPluginEnabled("ItemsAdder") && provided instanceof CustomBlockBreakEvent) {
            CustomBlockBreakEvent event = (CustomBlockBreakEvent)provided;
            return super.isRequiredItem(event.getCustomBlockItem(), progression);
        }
        if (PluginUtils.isPluginEnabled("CustomCrops") && provided instanceof CropBreakEvent) {
            CropBreakEvent event = (CropBreakEvent)provided;
            String cropNamespace = event.cropStageItemID();
            ItemStack cropItem = BreakQuest.getCustomItemStack(cropNamespace);
            if (cropItem == null) {
                Debugger.write("CropBreakListener: onCropBreak: The crop item " + cropNamespace + " does not exist.");
                return false;
            }
            return super.isRequiredItem(cropItem, progression);
        }
        return false;
    }

    private static ItemStack getCustomItemStack(String cropNamespace) {
        ItemBuilder itemBuilder;
        CustomStack customStack;
        if (ItemsAdderEnabled.isEnabled() && (customStack = CustomStack.getInstance((String)cropNamespace)) != null) {
            return customStack.getItemStack().clone();
        }
        if (OraxenEnabled.isEnabled() && (itemBuilder = OraxenItems.getItemById((String)cropNamespace)) != null) {
            return itemBuilder.build();
        }
        if (NexoEnabled.isEnabled() && (itemBuilder = NexoItems.itemFromId((String)cropNamespace)) != null) {
            return itemBuilder.build();
        }
        return null;
    }
}

