/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.item;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.events.listeners.item.custom.DropQueuePushListener;
import com.ordwen.odailyquests.externs.hooks.Protection;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import com.ordwen.odailyquests.tools.PluginUtils;
import com.willfp.eco.core.events.DropQueuePushEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FarmingQuest
extends ItemQuest {
    private static ItemStack current;

    public FarmingQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "FARMING";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        if (provided instanceof PlayerHarvestBlockEvent) {
            PlayerHarvestBlockEvent event = (PlayerHarvestBlockEvent)provided;
            return this.checkBlockAndProgress(event.getPlayer(), event.getHarvestedBlock(), progression, false, current);
        }
        if (provided instanceof BlockDropItemEvent) {
            BlockDropItemEvent event = (BlockDropItemEvent)provided;
            return this.checkBlockAndProgress(event.getPlayer(), event.getBlock(), progression, true, current);
        }
        if (provided instanceof BlockBreakEvent) {
            BlockBreakEvent event = (BlockBreakEvent)provided;
            return this.checkBlockAndProgress(event.getPlayer(), event.getBlock(), progression, false, null);
        }
        if (PluginUtils.isPluginEnabled("eco") && provided instanceof DropQueuePushEvent) {
            DropQueuePushEvent event = (DropQueuePushEvent)provided;
            return this.checkBlockAndProgress(event.getPlayer(), DropQueuePushListener.getCurrentState().getBlock(), progression, false, current);
        }
        return false;
    }

    private boolean checkBlockAndProgress(Player player, Block block, Progression progression, boolean rejectContainers, @Nullable ItemStack referenceItem) {
        ItemStack itemToCompare;
        if (rejectContainers && block.getState() instanceof InventoryHolder) {
            Debugger.write("FarmingQuest:canProgress: Block is a container.");
            return false;
        }
        if (!this.isProtectionBypass() && !Protection.canBuild(player, block, "BLOCK_BREAK")) {
            return false;
        }
        if (referenceItem != null) {
            itemToCompare = referenceItem;
        } else {
            itemToCompare = this.getNormalizedBlockItem(block.getType());
            if (itemToCompare == null) {
                return false;
            }
        }
        return super.isRequiredItem(itemToCompare, progression);
    }

    @Nullable
    private ItemStack getNormalizedBlockItem(Material material) {
        String blockType = material.name();
        if (blockType.endsWith("_PLANT")) {
            Debugger.write("FarmingQuest:canProgress: Block is a plant: " + blockType + ".");
            blockType = blockType.substring(0, blockType.length() - 6);
        }
        Debugger.write("FarmingQuest:canProgress: Potential vertical plant. Checking for type " + blockType + ".");
        Material itemMaterial = Material.getMaterial((String)blockType);
        if (itemMaterial == null || !itemMaterial.isItem()) {
            Debugger.write("FarmingQuest:canProgress: Material " + blockType + " is not valid.");
            return null;
        }
        return new ItemStack(itemMaterial);
    }

    public static void setCurrent(ItemStack current) {
        FarmingQuest.current = current;
    }
}

