/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.item;

import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class LaunchQuest
extends ItemQuest {
    private static final Map<String, String> ENTITY_TO_MATERIAL = Map.of("THROWN_EXP_BOTTLE", "EXPERIENCE_BOTTLE", "FIREWORK", "FIREWORK_ROCKET");

    public LaunchQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "LAUNCH";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        PlayerInteractEvent interactEvent;
        ItemStack item;
        if (provided instanceof ProjectileLaunchEvent) {
            ProjectileLaunchEvent event = (ProjectileLaunchEvent)provided;
            String entityName = event.getEntity().getType().name();
            String materialName = ENTITY_TO_MATERIAL.getOrDefault(entityName, entityName);
            try {
                Material material = Material.valueOf((String)materialName);
                return super.isRequiredItem(new ItemStack(material), progression);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if (provided instanceof PlayerInteractEvent && (item = (interactEvent = (PlayerInteractEvent)provided).getItem()) != null && item.getType() == Material.FIREWORK_ROCKET && interactEvent.getPlayer().isGliding()) {
            return super.isRequiredItem(item, progression);
        }
        return false;
    }
}

