/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.item;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.externs.hooks.Protection;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class PlaceQuest
extends ItemQuest {
    public PlaceQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "PLACE";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        if (provided instanceof BlockPlaceEvent) {
            BlockPlaceEvent event = (BlockPlaceEvent)provided;
            Block block = event.getBlock();
            if (!this.isProtectionBypass() && !Protection.canBuild(event.getPlayer(), block, "BLOCK_PLACE")) {
                return false;
            }
            ItemStack placedItem = event.getItemInHand();
            Debugger.write("BlockPlaceListener: onBlockPlaceEvent summoned by " + event.getPlayer().getName() + " for " + String.valueOf(placedItem.getType()) + ".");
            return super.isRequiredItem(new ItemStack(placedItem.getType()), progression);
        }
        return false;
    }
}

