/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.shared;

import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;

public abstract class EntityQuest
extends AbstractQuest {
    private final List<EntityType> requiredEntities = new ArrayList<EntityType>();
    protected DyeColor dyeColor;

    protected EntityQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        boolean hasRequired = section.contains(".required") || section.contains(".required_entity");
        boolean hasRandomRequired = section.contains(".random_required");
        if (hasRequired && hasRandomRequired) {
            PluginLogger.configurationError(file, index, "required/random_required", "You can't use 'required' and 'random_required' at the same time.");
            return false;
        }
        if (hasRandomRequired) {
            this.isRandomRequired = true;
            return this.loadRequiredEntities(section, file, index, ".random_required");
        }
        return this.loadRequiredEntities(section, file, index, ".required_entity") && this.loadRequiredEntities(section, file, index, ".required");
    }

    private boolean loadRequiredEntities(ConfigurationSection section, String file, String index, String path) {
        if (!section.contains(path)) {
            return true;
        }
        return path.contains("random_required") ? this.loadRandomRequiredEntities(section, file, index, path) : this.loadSimpleRequiredEntities(section, file, index, path);
    }

    private boolean loadRandomRequiredEntities(ConfigurationSection section, String file, String index, String path) {
        List rawList = section.getList(path);
        if (rawList == null || rawList.isEmpty()) {
            PluginLogger.configurationError(file, index, path, "The list of required entities is empty but 'random_required' is set.");
            return false;
        }
        for (Object entry : rawList) {
            if (!(entry instanceof Map)) {
                PluginLogger.configurationError(file, index, path, "Each entry in 'random_required' must be a map like - ZOMBIE: \"Display Name\"");
                return false;
            }
            Map mapEntry = (Map)entry;
            if (this.processRandomEntityMap(mapEntry, file, index)) continue;
            return false;
        }
        return true;
    }

    private boolean processRandomEntityMap(Map<?, ?> mapEntry, String file, String index) {
        for (Map.Entry<?, ?> element : mapEntry.entrySet()) {
            String key = element.getKey().toString();
            String displayName = element.getValue().toString();
            EntityType entityType = this.getEntityType(file, index, key);
            if (entityType == null) {
                return false;
            }
            this.requiredEntities.add(entityType);
            this.displayNames.add(displayName);
        }
        return true;
    }

    private boolean loadSimpleRequiredEntities(ConfigurationSection section, String file, String index, String path) {
        if (section.isString(path)) {
            EntityType single = this.getEntityType(file, index, section.getString(path));
            if (single == null) {
                return false;
            }
            this.requiredEntities.add(single);
            return true;
        }
        List presumed = section.getStringList(path);
        for (String name : presumed) {
            EntityType type = this.getEntityType(file, index, name);
            if (type == null) {
                return false;
            }
            this.requiredEntities.add(type);
            if (!this.isDisplayNameMissing(section, file, index, path, name)) continue;
            return false;
        }
        return true;
    }

    private EntityType getEntityType(String file, String index, String value) {
        try {
            return EntityType.valueOf((String)value);
        }
        catch (Exception e) {
            PluginLogger.configurationError(file, index, "required_entity", "Invalid entity type detected.");
            return null;
        }
    }

    public boolean isRequiredEntity(EntityType entityType, Progression progression) {
        if (this.isRandomRequired) {
            return entityType == this.requiredEntities.get(progression.getSelectedRequiredIndex());
        }
        return this.requiredEntities == null || this.requiredEntities.isEmpty() || this.requiredEntities.contains(entityType);
    }

    public List<EntityType> getRequiredEntities() {
        return this.requiredEntities;
    }
}

