/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.shared;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.getters.QuestItemGetter;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public abstract class ItemQuest
extends AbstractQuest {
    private static final Set<Material> POTIONS_TYPES = Set.of(Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION);
    private static final QuestItemGetter itemGetter = new QuestItemGetter();
    private final List<ItemStack> requiredItems = new ArrayList<ItemStack>();
    private boolean ignoreNbt = false;

    protected ItemQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        this.ignoreNbt = section.getBoolean(".ignore_nbt");
        boolean hasRequired = section.contains(".required") || section.contains(".required_item");
        boolean hasRandomRequired = section.contains(".random_required");
        if (hasRequired && hasRandomRequired) {
            PluginLogger.configurationError(file, index, "required/random_required", "You can't use 'required' and 'random_required' at the same time.");
            return false;
        }
        if (hasRandomRequired) {
            this.isRandomRequired = true;
            return this.loadRequiredItems(section, file, index, ".random_required");
        }
        return this.loadRequiredItems(section, file, index, ".required_item") && this.loadRequiredItems(section, file, index, ".required");
    }

    private boolean loadRequiredItems(ConfigurationSection section, String file, String index, String path) {
        if (!section.contains(path)) {
            return true;
        }
        return path.contains("random_required") ? this.loadRandomRequired(section, file, index, path) : this.loadSimpleRequired(section, file, index, path);
    }

    private boolean loadRandomRequired(ConfigurationSection section, String file, String index, String path) {
        List rawList = section.getList(path);
        if (rawList == null || rawList.isEmpty()) {
            PluginLogger.configurationError(file, index, path, "The list of required items is empty but 'random_required' is set.");
            return false;
        }
        for (Object entry : rawList) {
            if (!(entry instanceof Map)) {
                PluginLogger.configurationError(file, index, path, "Each entry in 'random_required' must be a map like - MATERIAL: \"Display Name\"");
                return false;
            }
            Map mapEntry = (Map)entry;
            if (this.processRandomMapEntry(section, mapEntry, file, index, path)) continue;
            return false;
        }
        return true;
    }

    private boolean processRandomMapEntry(ConfigurationSection section, Map<?, ?> mapEntry, String file, String index, String path) {
        for (Map.Entry<?, ?> element : mapEntry.entrySet()) {
            String key = element.getKey().toString();
            String displayName = element.getValue().toString();
            ItemStack requiredItem = this.getItem(section, key, file, index, path);
            if (requiredItem == null) {
                return false;
            }
            this.requiredItems.add(requiredItem);
            this.displayNames.add(displayName);
        }
        return true;
    }

    private boolean loadSimpleRequired(ConfigurationSection section, String file, String index, String path) {
        List<String> itemStrings = this.extractItemStrings(section, path);
        for (String type : itemStrings) {
            ItemStack requiredItem = this.getItem(section, type, file, index, path);
            if (requiredItem == null) {
                return false;
            }
            this.requiredItems.add(requiredItem);
        }
        return true;
    }

    private List<String> extractItemStrings(ConfigurationSection section, String path) {
        ArrayList<String> items = new ArrayList<String>();
        if (section.isList(path)) {
            items.addAll(section.getStringList(path));
        } else {
            String single = section.getString(path);
            if (single != null && !single.isEmpty()) {
                items.add(single);
            }
        }
        return items;
    }

    private ItemStack getItem(ConfigurationSection section, String type, String file, String index, String path) {
        PotionMeta potionMeta;
        if (type.equalsIgnoreCase("CUSTOM_ITEM")) {
            return itemGetter.loadCustomItem(section, file, index);
        }
        ItemStack requiredItem = itemGetter.getItemStackFromMaterial(type, file, index, path);
        if (requiredItem == null) {
            return null;
        }
        if (POTIONS_TYPES.contains(requiredItem.getType()) && (potionMeta = itemGetter.loadPotionItem(section, file, index, requiredItem)) != null) {
            requiredItem.setItemMeta((ItemMeta)potionMeta);
            this.updateMenuItem(potionMeta);
        }
        return requiredItem;
    }

    private void updateMenuItem(PotionMeta potionMeta) {
        ItemStack menuItem = this.getMenuItem();
        if (POTIONS_TYPES.contains(menuItem.getType())) {
            menuItem.setItemMeta((ItemMeta)potionMeta);
        }
    }

    public boolean isRequiredItem(ItemStack provided, Progression progression) {
        if (this.requiredItems == null || this.requiredItems.isEmpty()) {
            return true;
        }
        List<ItemStack> itemsToCheck = this.getItemsToCheck(progression);
        if (itemsToCheck.isEmpty()) {
            return false;
        }
        for (ItemStack item : itemsToCheck) {
            if (!this.matchesItem(item, provided)) continue;
            return true;
        }
        Debugger.write("ItemQuest:isRequiredItem: Item is not required.");
        return false;
    }

    private List<ItemStack> getItemsToCheck(Progression progression) {
        if (!this.isRandomRequired) {
            return this.requiredItems;
        }
        int index = progression.getSelectedRequiredIndex();
        if (index < 0 || index >= this.requiredItems.size()) {
            Debugger.write("ItemQuest:isRequiredItem: Invalid selectedRequiredIndex: " + index);
            return List.of();
        }
        return List.of(this.requiredItems.get(index));
    }

    private boolean matchesItem(ItemStack required, ItemStack provided) {
        Debugger.write("ItemQuest:isRequiredItem: Checking if item is required: " + String.valueOf(required.getType()) + " vs " + String.valueOf(provided.getType()) + ".");
        if (this.ignoreNbt && required.getType() == provided.getType()) {
            Debugger.write("ItemQuest:isRequiredItem: Ignoring NBT data.");
            return !POTIONS_TYPES.contains(required.getType()) || this.potionEquals(required, provided);
        }
        if (this.hasMatchingCustomModelData(required, provided)) {
            return true;
        }
        if (required.isSimilar(provided)) {
            Debugger.write("ItemQuest:isRequiredItem: Item is similar.");
            return true;
        }
        Debugger.write("ItemQuest:isRequiredItem: Item is not similar.");
        return false;
    }

    private boolean potionEquals(ItemStack required, ItemStack provided) {
        boolean sameExtended;
        Debugger.write("ItemQuest:isRequiredItem: Required item is a potion.");
        PotionMeta reqMeta = (PotionMeta)required.getItemMeta();
        PotionMeta provMeta = (PotionMeta)provided.getItemMeta();
        boolean sameType = reqMeta.getBasePotionData().getType() == provMeta.getBasePotionData().getType();
        boolean sameUpgrade = reqMeta.getBasePotionData().isUpgraded() == provMeta.getBasePotionData().isUpgraded();
        boolean bl = sameExtended = reqMeta.getBasePotionData().isExtended() == provMeta.getBasePotionData().isExtended();
        if (!sameType) {
            Debugger.write("ItemQuest:isRequiredItem: Potion type is different.");
        }
        if (!sameUpgrade) {
            Debugger.write("ItemQuest:isRequiredItem: Potion is upgraded.");
        }
        if (!sameExtended) {
            Debugger.write("ItemQuest:isRequiredItem: Potion is extended.");
        }
        return sameType && sameUpgrade && sameExtended;
    }

    private boolean hasMatchingCustomModelData(ItemStack required, ItemStack provided) {
        if (!required.hasItemMeta() || !required.getItemMeta().hasCustomModelData()) {
            return false;
        }
        Debugger.write("ItemQuest:isRequiredItem: Required item has custom model data.");
        if (provided.hasItemMeta() && provided.getItemMeta().hasCustomModelData()) {
            Debugger.write("ItemQuest:isRequiredItem: Provided item has custom model data.");
            return required.getType() == provided.getType() && required.getItemMeta().getCustomModelData() == provided.getItemMeta().getCustomModelData();
        }
        Debugger.write("ItemQuest:isRequiredItem: Provided item does not have custom model data.");
        return false;
    }

    public List<ItemStack> getRequiredItems() {
        return this.requiredItems;
    }
}

