/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DurationParser {
    private static final Pattern P = Pattern.compile("(\\d+)([dhm])");

    private DurationParser() {
    }

    public static Duration parseDuration(String interval) {
        Matcher matcher = P.matcher(interval);
        Duration duration = Duration.ZERO;
        while (matcher.find()) {
            String unit;
            int value = Integer.parseInt(matcher.group(1));
            duration = switch (unit = matcher.group(2)) {
                case "d" -> duration.plus((long)value, ChronoUnit.DAYS);
                case "h" -> duration.plus((long)value, ChronoUnit.HOURS);
                case "m" -> duration.plus((long)value, ChronoUnit.MINUTES);
                default -> duration;
            };
        }
        return duration;
    }
}

