/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.configuration.essentials.RenewInterval;
import com.ordwen.odailyquests.configuration.essentials.RenewTime;
import com.ordwen.odailyquests.configuration.essentials.TimestampMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class TimeRemain {
    private TimeRemain() {
    }

    public static String timeRemain(String playerName) {
        long rest;
        long timestamp = ODailyQuestsAPI.getPlayerQuests(playerName).getTimestamp();
        if (TimestampMode.getTimestampMode() == 1) {
            LocalTime renewTime = RenewTime.getRenewTime();
            ZoneId zone = RenewTime.getZoneId();
            ZonedDateTime lastRenew = Instant.ofEpochMilli(timestamp).atZone(zone);
            ZonedDateTime now = ZonedDateTime.now(zone);
            ZonedDateTime nextRenew = lastRenew.toLocalDate().plusDays(1L).atTime(renewTime).atZone(zone);
            if (nextRenew.isBefore(now)) {
                nextRenew = nextRenew.plusDays(1L);
            }
            rest = Duration.between(now, nextRenew).toMillis();
        } else {
            Duration renewDuration = RenewInterval.getRenewInterval();
            rest = renewDuration != null ? timestamp + renewDuration.toMillis() - System.currentTimeMillis() : 0L;
        }
        return TimeRemain.formatTimeRemain(rest);
    }

    private static String formatTimeRemain(long rest) {
        String d = RenewInterval.getDayInitial();
        String h = RenewInterval.getHourInitial();
        String m = RenewInterval.getMinuteInitial();
        int days = (int)(rest / 86400000L);
        int hours = (int)(rest / 3600000L % 24L);
        int minutes = (int)(rest / 60000L % 60L);
        String timeRemain = days != 0 ? String.format("%d%s%d%s%d%s", days, d, hours, h, minutes, m) : (hours != 0 ? String.format("%d%s%d%s", hours, h, minutes, m) : (minutes != 0 ? String.format("%d%s", minutes, m) : RenewInterval.getFewSeconds()));
        return timeRemain;
    }
}

