/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.externals;

import com.nexomc.nexo.api.NexoItems;
import com.ordwen.odailyquests.configuration.integrations.ItemsAdderEnabled;
import com.ordwen.odailyquests.configuration.integrations.NexoEnabled;
import com.ordwen.odailyquests.configuration.integrations.OraxenEnabled;
import com.ordwen.odailyquests.tools.ItemUtils;
import com.ordwen.odailyquests.tools.Pair;
import com.ordwen.odailyquests.tools.externals.IExternalItemGetter;
import dev.lone.itemsadder.api.CustomStack;
import io.th0rgal.oraxen.api.OraxenItems;
import java.lang.invoke.CallSite;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public abstract class ExternalItemGetter
implements IExternalItemGetter {
    @Override
    public Pair<String, ItemStack> getOraxenItem(String namespace) {
        if (!OraxenEnabled.isEnabled()) {
            return new Pair<String, Object>("Cannot find Oraxen. Is use_oraxen enabled in config?", null);
        }
        if (!OraxenItems.exists((String)namespace)) {
            return new Pair<CallSite, Object>((CallSite)((Object)("The item " + namespace + " does not exist in Oraxen.")), null);
        }
        return new Pair<String, ItemStack>("", OraxenItems.getItemById((String)namespace).build());
    }

    @Override
    public Pair<String, ItemStack> getNexoItem(String namespace) {
        if (!NexoEnabled.isEnabled()) {
            return new Pair<String, Object>("Cannot find Nexo. Is use_nexo enabled in config?", null);
        }
        if (!NexoItems.exists((String)namespace)) {
            return new Pair<CallSite, Object>((CallSite)((Object)("The item " + namespace + " does not exist in Nexo.")), null);
        }
        return new Pair<String, ItemStack>("", NexoItems.itemFromId((String)namespace).build());
    }

    @Override
    public Pair<String, ItemStack> getItemsAdderItem(String namespace) {
        if (!ItemsAdderEnabled.isEnabled()) {
            return new Pair<String, Object>("Cannot find ItemsAdder. Is use_itemsadder enabled in config?", null);
        }
        if (!namespace.contains(":")) {
            return new Pair<String, Object>("You need to provide the namespace and the id of the item.", null);
        }
        if (!CustomStack.isInRegistry((String)namespace)) {
            return new Pair<CallSite, Object>((CallSite)((Object)("The item " + namespace + " does not exist in ItemsAdder.")), null);
        }
        return new Pair<String, ItemStack>("", CustomStack.getInstance((String)namespace).getItemStack().clone());
    }

    @Override
    public Pair<String, ItemStack> getMMOItemsItem(String namespace) {
        if (Bukkit.getServer().getPluginManager().getPlugin("MMOItems") == null) {
            return new Pair<String, Object>("MMOItems is not enabled.", null);
        }
        if (!namespace.contains(":")) {
            return new Pair<String, Object>("You need to provide the category and the id of the item.", null);
        }
        String[] split = namespace.split(":", 2);
        Type type = MMOItems.plugin.getTypes().get(split[0]);
        if (type == null) {
            return new Pair<CallSite, Object>((CallSite)((Object)("The category " + split[0] + " does not exist in MMOItems.")), null);
        }
        MMOItem item = MMOItems.plugin.getMMOItem(type, split[1]);
        if (item == null) {
            return new Pair<CallSite, Object>((CallSite)((Object)("The item " + split[1] + " does not exist in MMOItems.")), null);
        }
        return new Pair<String, ItemStack>("", item.newBuilder().build());
    }

    @Override
    public Pair<String, ItemStack> getCustomHead(String texture) {
        return new Pair<String, ItemStack>("", ItemUtils.getCustomHead(texture));
    }
}

