/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.config;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.UpdateChecker;
import com.ordwen.odailyquests.tools.updater.config.IConfigUpdater;
import com.ordwen.odailyquests.tools.updater.config.updates.Update223to224;
import com.ordwen.odailyquests.tools.updater.config.updates.Update225to230;
import com.ordwen.odailyquests.tools.updater.config.updates.Update230to300;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigUpdateManager {
    private final ODailyQuests plugin;
    private final Map<String, IConfigUpdater> updaters = new LinkedHashMap<String, IConfigUpdater>();

    public ConfigUpdateManager(ODailyQuests plugin) {
        this.plugin = plugin;
        this.updaters.put("2.2.3", new Update223to224(plugin));
        this.updaters.put("2.2.5", new Update225to230(plugin));
        this.updaters.put("3.0.0", new Update230to300(plugin));
    }

    public void runUpdates() {
        FileConfiguration configFile = this.plugin.getFilesManager().getConfigurationFile().getConfig();
        String buildVersion = this.plugin.getDescription().getVersion();
        int separatorIndex = buildVersion.indexOf(45);
        String currentVersion = separatorIndex == -1 ? buildVersion : buildVersion.substring(0, separatorIndex);
        String configVersion = configFile.getString("version", "0.0.0");
        for (Map.Entry<String, IConfigUpdater> entry : this.updaters.entrySet()) {
            String updateVersion = entry.getKey();
            IConfigUpdater updater = entry.getValue();
            if (UpdateChecker.compareVersions(configVersion, updateVersion) >= 0) continue;
            PluginLogger.warn("Applying update: " + updateVersion);
            updater.apply(this.plugin, currentVersion);
        }
        this.plugin.saveConfig();
    }
}

