/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.config.updates;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.updater.config.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.configuration.ConfigurationSection;

public class Update230to300
extends ConfigUpdater {
    private static final String TEMPORALITY_MODE = "temporality_mode";
    private static final String RENEW_INTERVAL = "renew_interval";

    public Update230to300(ODailyQuests plugin) {
        super(plugin);
    }

    @Override
    public void apply(ODailyQuests plugin, String version) {
        if (this.config.getString("storage_mode").equalsIgnoreCase("h2")) {
            this.config.set("storage_mode", (Object)"SQLite");
            try {
                this.config.save(this.configFile);
                PluginLogger.warn("For stability reasons, the storage mode has been changed from H2 to SQLite.");
                PluginLogger.warn("The migration will be done automatically. If you encounter any issues, please contact support.");
            }
            catch (IOException e) {
                PluginLogger.error("Error while saving the configuration file.");
                PluginLogger.error(e.getMessage());
            }
        }
        this.setDefaultConfigItem("safety_mode", true, this.config, this.configFile, false);
        this.setDefaultConfigItem("join_message_delay", 1.0, this.config, this.configFile, false);
        this.setDefaultConfigItem("use_nexo", false, this.config, this.configFile, false);
        this.setDefaultConfigItem("renew_time", "00:00", this.config, this.configFile, false);
        this.setDefaultConfigItem("check_for_update", true, this.config, this.configFile, false);
        this.setDefaultConfigItem("player_data_load_delay", 0.5, this.config, this.configFile, false);
        this.setDefaultConfigItem("use_rosestacker", false, this.config, this.configFile, false);
        this.setDefaultConfigItem("complete_only_on_click", false, this.config, this.configFile, false);
        this.setDefaultConfigItem("toast.enabled", false, this.config, this.configFile, false);
        this.setDefaultConfigItem("toast.frame", "CHALLENGE", this.config, this.configFile, false);
        this.setDefaultConfigItem("toast.icon", "BOOK", this.config, this.configFile, false);
        this.setDefaultConfigItem("toast.text", "&b&lQuest completed!\\n%questName%", this.config, this.configFile, false);
        this.setDefaultConfigItem("prefix", "", this.config, this.configFile, true);
        this.replaceTemporalityMode();
        this.replaceQuestsAmount();
        this.replaceInterfaceNames();
        this.replaceNPCNames();
        this.renameQuestFiles();
        this.cleanupCategoryRewards();
        this.updateVersion(version);
    }

    private void replaceTemporalityMode() {
        int currentMode = this.config.getInt(TEMPORALITY_MODE);
        switch (currentMode) {
            case 2: {
                this.setDefaultConfigItem(RENEW_INTERVAL, "7d", this.config, this.configFile, false);
                break;
            }
            case 3: {
                this.setDefaultConfigItem(RENEW_INTERVAL, "30d", this.config, this.configFile, false);
                break;
            }
            default: {
                this.setDefaultConfigItem(RENEW_INTERVAL, "1d", this.config, this.configFile, false);
            }
        }
        this.removeConfigItem(TEMPORALITY_MODE, this.config, this.configFile);
        this.parameterReplaced(TEMPORALITY_MODE, RENEW_INTERVAL);
    }

    private void replaceQuestsAmount() {
        int currentMode = this.config.getInt("quests_mode");
        if (currentMode == 1) {
            int globalAmount = this.config.getInt("global_quests_amount");
            this.setDefaultConfigItem("quests_per_category.global", globalAmount, this.config, this.configFile, false);
        } else {
            int easyAmount = this.config.getInt("easy_quests_amount");
            int mediumAmount = this.config.getInt("medium_quests_amount");
            int hardAmount = this.config.getInt("hard_quests_amount");
            if (easyAmount > 0) {
                this.setDefaultConfigItem("quests_per_category.easy", easyAmount, this.config, this.configFile, false);
            }
            if (mediumAmount > 0) {
                this.setDefaultConfigItem("quests_per_category.medium", mediumAmount, this.config, this.configFile, false);
            }
            if (hardAmount > 0) {
                this.setDefaultConfigItem("quests_per_category.hard", hardAmount, this.config, this.configFile, false);
            }
        }
        this.removeConfigItem("quests_mode", this.config, this.configFile);
        this.removeConfigItem("global_quests_amount", this.config, this.configFile);
        this.removeConfigItem("easy_quests_amount", this.config, this.configFile);
        this.removeConfigItem("medium_quests_amount", this.config, this.configFile);
        this.removeConfigItem("hard_quests_amount", this.config, this.configFile);
    }

    private void replaceInterfaceNames() {
        String[] oldInterfaceNames = new String[]{"global_quests", "easy_quests", "medium_quests", "hard_quests"};
        String[] newInterfaceNames = new String[]{"global", "easy", "medium", "hard"};
        ConfigurationSection section = this.config.getConfigurationSection("interfaces");
        if (section == null) {
            PluginLogger.error("Interfaces section is missing in the configuration file. Disabling.");
            return;
        }
        int i = 0;
        for (String interfaceName : oldInterfaceNames) {
            String inventoryName = section.getString(interfaceName + ".inventory_name");
            String emptyItem = section.getString(interfaceName + ".empty_item");
            this.setDefaultConfigItem("interfaces." + newInterfaceNames[i] + ".inventory_name", inventoryName, this.config, this.configFile, false);
            this.setDefaultConfigItem("interfaces." + newInterfaceNames[i] + ".empty_item", emptyItem, this.config, this.configFile, false);
            this.removeConfigItem("interfaces." + interfaceName, this.config, this.configFile);
            this.parameterReplaced("interfaces." + interfaceName, "interfaces." + newInterfaceNames[i]);
            ++i;
        }
    }

    private void replaceNPCNames() {
        String[] oldNPCNames = new String[]{"name_player", "name_global", "name_easy", "name_medium", "name_hard"};
        String[] newNPCNames = new String[]{"player", "global", "easy", "medium", "hard"};
        int i = 0;
        for (String NPCName : oldNPCNames) {
            String name = this.config.getString("npcs." + NPCName);
            this.setDefaultConfigItem("npcs." + newNPCNames[i], name, this.config, this.configFile, false);
            this.removeConfigItem("npcs." + NPCName, this.config, this.configFile);
            this.parameterReplaced(NPCName, newNPCNames[i]);
            ++i;
        }
    }

    private void renameQuestFiles() {
        File questsFolder = new File(ODailyQuests.INSTANCE.getDataFolder(), "quests");
        if (!questsFolder.exists() || !questsFolder.isDirectory()) {
            PluginLogger.warn("Quests folder does not exist or is not a directory.");
            return;
        }
        File[] files = questsFolder.listFiles();
        if (files == null) {
            PluginLogger.warn("No files found in the quests directory.");
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith("Quests.yml")) continue;
            String newName = file.getName().replace("Quests", "");
            File newFile = new File(questsFolder, newName);
            if (file.renameTo(newFile)) {
                PluginLogger.warn("Renamed " + file.getName() + " to " + newFile.getName());
                continue;
            }
            PluginLogger.error("Failed to rename " + file.getName());
        }
    }

    private void cleanupCategoryRewards() {
        ConfigurationSection rewards = this.config.getConfigurationSection("categories_rewards");
        if (rewards == null) {
            return;
        }
        int kept = 0;
        for (String cat : new HashSet(rewards.getKeys(false))) {
            ConfigurationSection catSec = rewards.getConfigurationSection(cat);
            if (catSec == null) {
                rewards.set(cat, null);
                continue;
            }
            boolean enabled = catSec.getBoolean("enabled", true);
            if (!enabled) {
                rewards.set(cat, null);
                continue;
            }
            if (catSec.contains("enabled")) {
                catSec.set("enabled", null);
            }
            ++kept;
        }
        if (kept == 0) {
            this.config.set("categories_rewards", new ArrayList());
            PluginLogger.warn("No active category rewards found. Set categories_rewards to an empty list [] to avoid load errors.");
        }
    }
}

