/*
 * Decompiled with CFR 0.152.
 */
package com.ba22.createelectrolysis;

import com.ba22.createelectrolysis.ModBlockEntities;
import com.ba22.createelectrolysis.ModFluidHydrogen;
import com.ba22.createelectrolysis.ModFluidOxygen;
import com.ba22.createelectrolysis.MyEntityBlock;
import com.ba22.createelectrolysis.MyModCapabilities;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="createelectrolysis")
public class CreateElectrolysis {
    public static final String MODID = "createelectrolysis";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"createelectrolysis");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"createelectrolysis");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"createelectrolysis");
    public static final DeferredBlock<MyEntityBlock> ELECTROLYSER = BLOCKS.register("electrolyser", () -> new MyEntityBlock(BlockBehaviour.Properties.of().noOcclusion()));
    public static final DeferredItem<BlockItem> ELECTROLYSER_ITEM = ITEMS.registerSimpleBlockItem("electrolyser", ELECTROLYSER);
    public static final DeferredItem<Item> RODS_ITEM = ITEMS.registerSimpleItem("rods", new Item.Properties().food(new FoodProperties.Builder().alwaysEdible().nutrition(1).saturationModifier(2.0f).build()));
    public static final DeferredHolder<Item, BucketItem> HYDROGEN_BUCKET = ModFluidHydrogen.getBucket();
    public static final DeferredHolder<Item, BucketItem> OXYGEN_BUCKET = ModFluidOxygen.getBucket();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.createelectrolysis")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((BlockItem)ELECTROLYSER_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)RODS_ITEM.get());
        output.accept((ItemLike)ELECTROLYSER_ITEM.get());
        output.accept((ItemLike)HYDROGEN_BUCKET.get());
        output.accept((ItemLike)OXYGEN_BUCKET.get());
    }).build());

    public CreateElectrolysis(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(MyModCapabilities::registerCapabilities);
        ITEMS.register(modEventBus);
        ModFluidHydrogen.register(modEventBus);
        ModFluidOxygen.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.isClientSide) {
            return;
        }
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack heldItem = event.getItemStack();
        BlockState state = level.getBlockState(pos);
        Registry blockRegistry = level.registryAccess().registryOrThrow(Registries.BLOCK);
        ResourceLocation id = blockRegistry.getKey((Object)state.getBlock());
        if (id != null && id.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"create", (String)"basin")) && heldItem.getItem() == RODS_ITEM.get()) {
            level.setBlock(pos, ((MyEntityBlock)((Object)ELECTROLYSER.get())).defaultBlockState(), 3);
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

