/*
 * Decompiled with CFR 0.152.
 */
package com.ba22.createelectrolysis;

import com.ba22.createelectrolysis.CreateElectrolysis;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModFluidHydrogen {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"createelectrolysis");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"createelectrolysis");
    public static final DeferredRegister<Item> BUCKETS = DeferredRegister.createItems((String)"createelectrolysis");
    public static final DeferredRegister<Block> SOURCEBLOCKS = DeferredRegister.createBlocks((String)"createelectrolysis");
    public static final DeferredHolder<FluidType, FluidType> LIQUID_TYPE = FLUID_TYPES.register("hydrogen", () -> new FluidType(FluidType.Properties.create().descriptionId("fluid.createelectrolysis.hydrogen")));
    public static final DeferredHolder<Fluid, FlowingFluid> LIQUID_SOURCE = FLUIDS.register("hydrogen_source", () -> new BaseFlowingFluid.Source(ModFluidHydrogen.liquidProperties()));
    public static final DeferredHolder<Fluid, FlowingFluid> LIQUID_FLOWING = FLUIDS.register("hydrogen_flowing", () -> new BaseFlowingFluid.Flowing(ModFluidHydrogen.liquidProperties()));
    public static final DeferredHolder<Item, BucketItem> LIQUID_BUCKET = BUCKETS.register("hydrogen_bucket", () -> new BucketItem((Fluid)LIQUID_SOURCE.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final DeferredHolder<Block, LiquidBlock> LIQUID_BLOCK = SOURCEBLOCKS.register("hydrogen_block", () -> new LiquidBlock((FlowingFluid)LIQUID_SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    private static final IClientFluidTypeExtensions liquidExt = new IClientFluidTypeExtensions(){

        public ResourceLocation getStillTexture() {
            return CreateElectrolysis.rl("block/hydrogen_still");
        }

        public ResourceLocation getFlowingTexture() {
            return CreateElectrolysis.rl("block/hydrogen_flowing");
        }
    };

    public static void register(IEventBus modbus) {
        FLUID_TYPES.register(modbus);
        FLUIDS.register(modbus);
        BUCKETS.register(modbus);
        SOURCEBLOCKS.register(modbus);
        modbus.addListener(ModFluidHydrogen::clientExt);
    }

    public static DeferredHolder<Item, BucketItem> getBucket() {
        return LIQUID_BUCKET;
    }

    private static void clientExt(RegisterClientExtensionsEvent event) {
        event.registerFluidType(liquidExt, new FluidType[]{(FluidType)LIQUID_TYPE.get()});
    }

    private static BaseFlowingFluid.Properties liquidProperties() {
        return new BaseFlowingFluid.Properties(LIQUID_TYPE, LIQUID_SOURCE, LIQUID_FLOWING).bucket(LIQUID_BUCKET);
    }
}

