/*
 * Decompiled with CFR 0.152.
 */
package com.ba22.createelectrolysis;

import com.ba22.createelectrolysis.ModBlockEntities;
import com.ba22.createelectrolysis.ModFluidHydrogen;
import com.ba22.createelectrolysis.ModFluidOxygen;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class MyBlockEntity
extends BlockEntity {
    private final EnergyStorage energyStorage = new EnergyStorage(100000);
    private final FluidTank hydrogenTank = new FluidTank(4000, stack -> stack.getFluid().isSame((Fluid)ModFluidHydrogen.LIQUID_SOURCE.get()));
    private final FluidTank oxygenTank = new FluidTank(2000, stack -> stack.getFluid().isSame((Fluid)ModFluidOxygen.LIQUID_SOURCE.get()));
    private final FluidTank waterTank = new FluidTank(6000, stack -> stack.getFluid().isSame((Fluid)Fluids.WATER));
    private final IFluidHandler CombinedHandler = new CombinedTankWrapper(new IFluidHandler[]{this.waterTank, this.hydrogenTank, this.oxygenTank});
    public final IFluidHandler routerHandler = new IFluidHandler(){

        public int getTanks() {
            return 3;
        }

        public FluidStack getFluidInTank(int tank) {
            return switch (tank) {
                case 0 -> MyBlockEntity.this.waterTank.getFluid();
                case 1 -> MyBlockEntity.this.hydrogenTank.getFluid();
                case 2 -> MyBlockEntity.this.oxygenTank.getFluid();
                default -> FluidStack.EMPTY;
            };
        }

        public int getTankCapacity(int tank) {
            return switch (tank) {
                case 0 -> MyBlockEntity.this.waterTank.getCapacity();
                case 1 -> MyBlockEntity.this.hydrogenTank.getCapacity();
                case 2 -> MyBlockEntity.this.oxygenTank.getCapacity();
                default -> 0;
            };
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return switch (tank) {
                case 0 -> MyBlockEntity.this.waterTank.isFluidValid(stack);
                case 1 -> MyBlockEntity.this.hydrogenTank.isFluidValid(stack);
                case 2 -> MyBlockEntity.this.oxygenTank.isFluidValid(stack);
                default -> false;
            };
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (MyBlockEntity.this.waterTank.isFluidValid(resource)) {
                return MyBlockEntity.this.waterTank.fill(resource, action);
            }
            if (MyBlockEntity.this.hydrogenTank.isFluidValid(resource)) {
                return MyBlockEntity.this.hydrogenTank.fill(resource, action);
            }
            if (MyBlockEntity.this.oxygenTank.isFluidValid(resource)) {
                return MyBlockEntity.this.oxygenTank.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (MyBlockEntity.this.waterTank.isFluidValid(resource)) {
                return MyBlockEntity.this.waterTank.drain(resource, action);
            }
            if (MyBlockEntity.this.hydrogenTank.isFluidValid(resource)) {
                return MyBlockEntity.this.hydrogenTank.drain(resource, action);
            }
            if (MyBlockEntity.this.oxygenTank.isFluidValid(resource)) {
                return MyBlockEntity.this.oxygenTank.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!MyBlockEntity.this.waterTank.isEmpty()) {
                return MyBlockEntity.this.waterTank.drain(maxDrain, action);
            }
            if (!MyBlockEntity.this.hydrogenTank.isEmpty()) {
                return MyBlockEntity.this.hydrogenTank.drain(maxDrain, action);
            }
            if (!MyBlockEntity.this.oxygenTank.isEmpty()) {
                return MyBlockEntity.this.oxygenTank.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };

    public MyBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.MY_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MyBlockEntity be) {
        boolean hasEnergy;
        if (level.isClientSide) {
            return;
        }
        int waterNeeded = 30;
        int energyNeeded = 10;
        FluidStack hydrogenOut = new FluidStack((Fluid)ModFluidHydrogen.LIQUID_SOURCE.get(), 20);
        FluidStack oxygenOut = new FluidStack((Fluid)ModFluidOxygen.LIQUID_SOURCE.get(), 10);
        boolean hasWater = be.getWaterTank().drain(waterNeeded, IFluidHandler.FluidAction.SIMULATE).getAmount() == waterNeeded;
        boolean bl = hasEnergy = be.getEnergyStorage().extractEnergy(energyNeeded, true) == energyNeeded;
        if (hasWater && hasEnergy) {
            boolean canOxygen;
            boolean canHydrogen = be.getHydrogenTank().fill(hydrogenOut, IFluidHandler.FluidAction.SIMULATE) == hydrogenOut.getAmount();
            boolean bl2 = canOxygen = be.getOxygenTank().fill(oxygenOut, IFluidHandler.FluidAction.SIMULATE) == oxygenOut.getAmount();
            if (canHydrogen && canOxygen) {
                be.getWaterTank().drain(waterNeeded, IFluidHandler.FluidAction.EXECUTE);
                be.getEnergyStorage().extractEnergy(energyNeeded, false);
                be.getHydrogenTank().fill(hydrogenOut, IFluidHandler.FluidAction.EXECUTE);
                be.getOxygenTank().fill(oxygenOut, IFluidHandler.FluidAction.EXECUTE);
                MyBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTank getHydrogenTank() {
        return this.hydrogenTank;
    }

    public FluidTank getOxygenTank() {
        return this.oxygenTank;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public IFluidHandler getCombinedHandler() {
        return this.CombinedHandler;
    }
}

