/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.datagen.family;

import com.brand.blockus.registry.content.BlockusBlocks;
import com.brand.blockus.registry.content.bundles.CopperBSSWBundle;
import com.brand.blockus.registry.content.bundles.WoodBundle;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_5794;
import net.minecraft.class_7923;

public class BlockusFamilies {
    public static final class_5794 WHITE_OAK;
    public static final class_5794 CHARRED;
    public static final class_5794 RAW_BAMBOO;
    public static final CopperFamily COPPER_BRICKS;
    public static final CopperFamily EXPOSED_COPPER_BRICKS;
    public static final CopperFamily WEATHERED_COPPER_BRICKS;
    public static final CopperFamily OXIDIZED_COPPER_BRICKS;
    public static final CopperFamily COPPER_TUFF_BRICKS;
    public static final CopperFamily EXPOSED_COPPER_TUFF_BRICKS;
    public static final CopperFamily WEATHERED_COPPER_TUFF_BRICKS;
    public static final CopperFamily OXIDIZED_COPPER_TUFF_BRICKS;
    public static final Map<class_2248, class_5794> BASE_BLOCKS_TO_FAMILIES;

    public static CopperFamily register(CopperBSSWBundle block) {
        class_5794 unwaxed = BlockusFamilies.register(block.block()).method_33492(block.slab()).method_33493(block.stairs()).method_33497(block.wall()).method_33485().method_33481();
        class_5794 waxed = BlockusFamilies.register(block.blockWaxed()).method_33492(block.slabWaxed()).method_33493(block.stairsWaxed()).method_33497(block.wallWaxed()).method_33484("waxed_" + class_7923.field_41175.method_10221((Object)block.block()).method_12832()).method_33485().method_33481();
        return new CopperFamily(unwaxed, waxed);
    }

    public static class_5794 register(WoodBundle wood, boolean customFence) {
        class_5794.class_5795 builder = BlockusFamilies.register(wood.planks()).method_33482(wood.button()).method_33494(wood.pressurePlate()).method_33483(wood.standingSign(), wood.wallSign()).method_33492(wood.slab()).method_33493(wood.stairs()).method_33489(wood.door()).method_33496(wood.trapdoor()).method_33484("wooden").method_33487("has_planks");
        if (customFence) {
            builder.method_45966(wood.fence()).method_45967(wood.fenceGate());
        } else {
            builder.method_33490(wood.fence()).method_33491(wood.fenceGate());
        }
        return builder.method_33481();
    }

    public static class_5794.class_5795 register(class_2248 baseBlock) {
        class_5794.class_5795 builder = new class_5794.class_5795(baseBlock);
        class_5794 blockFamily = BASE_BLOCKS_TO_FAMILIES.put(baseBlock, builder.method_33481());
        if (blockFamily != null) {
            throw new IllegalStateException("Duplicate family definition for " + String.valueOf(class_7923.field_41175.method_10221((Object)baseBlock)));
        }
        return builder;
    }

    public static Stream<class_5794> getFamilies() {
        return BASE_BLOCKS_TO_FAMILIES.values().stream();
    }

    static {
        BASE_BLOCKS_TO_FAMILIES = Maps.newHashMap();
        WHITE_OAK = BlockusFamilies.register(BlockusBlocks.WHITE_OAK, false);
        CHARRED = BlockusFamilies.register(BlockusBlocks.CHARRED, false);
        RAW_BAMBOO = BlockusFamilies.register(BlockusBlocks.RAW_BAMBOO, true);
        COPPER_BRICKS = BlockusFamilies.register(BlockusBlocks.COPPER_BRICKS);
        EXPOSED_COPPER_BRICKS = BlockusFamilies.register(BlockusBlocks.EXPOSED_COPPER_BRICKS);
        WEATHERED_COPPER_BRICKS = BlockusFamilies.register(BlockusBlocks.WEATHERED_COPPER_BRICKS);
        OXIDIZED_COPPER_BRICKS = BlockusFamilies.register(BlockusBlocks.OXIDIZED_COPPER_BRICKS);
        COPPER_TUFF_BRICKS = BlockusFamilies.register(BlockusBlocks.COPPER_TUFF_BRICKS);
        EXPOSED_COPPER_TUFF_BRICKS = BlockusFamilies.register(BlockusBlocks.EXPOSED_COPPER_TUFF_BRICKS);
        WEATHERED_COPPER_TUFF_BRICKS = BlockusFamilies.register(BlockusBlocks.WEATHERED_COPPER_TUFF_BRICKS);
        OXIDIZED_COPPER_TUFF_BRICKS = BlockusFamilies.register(BlockusBlocks.OXIDIZED_COPPER_TUFF_BRICKS);
    }

    public static class CopperFamily {
        public final class_5794 unwaxed;
        public final class_5794 waxed;

        public CopperFamily(class_5794 unwaxed, class_5794 waxed) {
            this.unwaxed = unwaxed;
            this.waxed = waxed;
        }
    }
}

