/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.registry.content.bundles.BSSWBundle;
import com.brand.blockus.utils.helper.WoodMaps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2248;

public class ExtraWoodBundle<T> {
    private final Map<String, T> blocks;

    private ExtraWoodBundle(Map<String, T> blocks) {
        this.blocks = Map.copyOf(blocks);
    }

    public Map<String, T> bundle() {
        return this.blocks;
    }

    public T get(String wood) {
        return this.blocks.get(wood);
    }

    public static <T> ExtraWoodBundle<T> of(Function<String, T> blockFactory) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (WoodMaps wood : WoodMaps.values()) {
            T block = blockFactory.apply(wood.getId());
            if (block == null) continue;
            map.put(wood.getId(), block);
        }
        return new ExtraWoodBundle(map);
    }

    public static ExtraWoodBundle<BSSWBundle> of(Function<String, String> string, Function<String, class_2248> baseBlockProvider) {
        return ExtraWoodBundle.of(string, baseBlockProvider, Set.of());
    }

    public static ExtraWoodBundle<BSSWBundle> of(Function<String, String> string, Function<String, class_2248> baseBlockProvider, Set<WoodMaps> exclude) {
        LinkedHashMap<String, BSSWBundle> map = new LinkedHashMap<String, BSSWBundle>();
        for (WoodMaps wood : WoodMaps.values()) {
            if (exclude.contains((Object)wood)) continue;
            String id = string.apply(wood.getId());
            class_2248 baseBlock = baseBlockProvider.apply(wood.getId());
            BSSWBundle bundle = BSSWBundle.of(id, baseBlock).includeWall(false).register();
            map.put(wood.getId(), bundle);
        }
        return new ExtraWoodBundle<BSSWBundle>(map);
    }

    public static Set<WoodMaps> exclude(WoodMaps ... types) {
        return Set.of(types);
    }
}

