/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.registry.content.BlockusItems;
import com.brand.blockus.utils.helper.BlockFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11586;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2766;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8177;

public record WoodBundle(String type, boolean burnable, class_2248 base, class_2248 planks, class_2248 stairs, class_2248 slab, class_2248 fence, class_2248 fenceGate, class_2248 door, class_2248 trapdoor, class_2248 pressurePlate, class_2248 button, class_2248 shelf, class_2248 standingSign, class_2248 wallSign, class_1792 sign, class_2248 ceilingHangingSign, class_2248 wallHangingSign, class_1792 hangingSign) {
    public static final List<WoodBundle> LIST = new ArrayList<WoodBundle>();

    public static List<WoodBundle> values() {
        return LIST;
    }

    public static Builder of(String type, class_2248 base, class_3620 color, class_2498 sound, class_4719 woodType, class_8177 blockSetType, boolean burnable) {
        return new Builder(type, base, color, sound, woodType, blockSetType, burnable);
    }

    public static class_4970.class_2251 copyLootTable(class_2248 block, class_3620 color, boolean burnable) {
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_63502(block.method_26162()).method_63501(block.method_63499()).method_31710(color).method_51369().method_51368(class_2766.field_12651).method_9634().method_9632(1.0f);
        if (burnable) {
            settings = settings.method_50013();
        }
        return settings;
    }

    public static class Builder {
        public final String type;
        public final class_2248 base;
        public final class_3620 color;
        public final class_2498 sound;
        public final class_4719 woodType;
        public final class_8177 blockSetType;
        public final boolean burnable;

        public Builder(String type, class_2248 base, class_3620 color, class_2498 sound, class_4719 woodType, class_8177 blockSetType, boolean burnable) {
            this.type = type;
            this.base = base;
            this.color = color;
            this.sound = sound;
            this.woodType = woodType;
            this.blockSetType = blockSetType;
            this.burnable = burnable;
        }

        public WoodBundle register() {
            class_4970.class_2251 blockSettings = BlockFactory.create().method_31710(this.color).method_51368(class_2766.field_12651).method_9629(2.0f, 3.0f).method_9626(this.sound);
            class_4970.class_2251 doorTrapdoorSettings = BlockFactory.doorTrapdoorBlockSettings(0.1f, 0.8f, this.sound, this.color, class_2766.field_12651);
            class_4970.class_2251 signSettings = BlockFactory.create().method_31710(this.color).method_9634().method_9632(1.0f);
            class_4970.class_2251 shelfSettings = BlockFactory.create().method_31710(this.color).method_51368(class_2766.field_12651).method_9626(class_2498.field_61430).method_9629(2.0f, 3.0f);
            if (this.burnable) {
                blockSettings = blockSettings.method_50013();
                doorTrapdoorSettings = doorTrapdoorSettings.method_50013();
                signSettings = signSettings.method_50013();
                shelfSettings = signSettings.method_50013();
            }
            class_2248 planks = BlockFactory.registerOf(this.type + "_planks", blockSettings);
            class_2248 stairs = BlockFactory.stairs(planks);
            class_2248 slab = BlockFactory.slab(planks);
            class_2248 fence = BlockFactory.registerCopy(this.type + "_fence", class_2354::new, this.base);
            class_2248 fenceGate = BlockFactory.registerCopy(this.type + "_fence_gate", settings -> new class_2349(this.woodType, settings), this.base);
            class_2248 door = BlockFactory.registerOf(this.type + "_door", settings -> new class_2323(this.blockSetType, settings), doorTrapdoorSettings);
            class_2248 trapdoor = BlockFactory.registerOf(this.type + "_trapdoor", settings -> new class_2533(this.blockSetType, settings), doorTrapdoorSettings);
            class_2248 pressurePlate = BlockFactory.pressurePlate(planks, this.blockSetType);
            class_2248 button = BlockFactory.button(planks, this.blockSetType, 30);
            class_2248 shelf = BlockFactory.registerOf(this.type + "_shelf", class_11586::new, shelfSettings);
            class_2248 standingSign = BlockFactory.registerNoItem(this.type + "_sign", settings -> new class_2508(this.woodType, settings), signSettings);
            class_2248 wallSign = BlockFactory.registerNoItem(this.type + "_wall_sign", settings -> new class_2551(this.woodType, settings), WoodBundle.copyLootTable(standingSign, this.color, this.burnable));
            class_1792 sign = BlockusItems.register(standingSign, (block, settings) -> new class_1822(block, wallSign, settings), new class_1792.class_1793().method_7889(16));
            class_2248 ceilingHangingSign = BlockFactory.registerNoItem(this.type + "_hanging_sign", settings -> new class_7713(this.woodType, settings), signSettings);
            class_2248 wallHangingSign = BlockFactory.registerNoItem(this.type + "_wall_hanging_sign", settings -> new class_7715(this.woodType, settings), WoodBundle.copyLootTable(ceilingHangingSign, this.color, this.burnable));
            class_1792 hangingSign = BlockusItems.register(ceilingHangingSign, (block, settings) -> new class_7707(block, wallHangingSign, settings), new class_1792.class_1793().method_7889(16));
            WoodBundle bundle = new WoodBundle(this.type, this.burnable, this.base, planks, stairs, slab, fence, fenceGate, door, trapdoor, pressurePlate, button, shelf, standingSign, wallSign, sign, ceilingHangingSign, wallHangingSign, hangingSign);
            LIST.add(bundle);
            return bundle;
        }
    }
}

