/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.utils.helper.BlockFactory;
import com.brand.blockus.utils.helper.BlockMaps;
import com.brand.blockus.utils.helper.BlockOrder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_5815;

public record WoolBundle(Map<class_1767, WoolVariants> colorMap) {
    public static final List<WoolBundle> LIST = new ArrayList<WoolBundle>();

    public static List<WoolBundle> values() {
        return LIST;
    }

    public static Builder of(String id) {
        return new Builder(id);
    }

    public List<class_2248> all() {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        for (class_1767 color : BlockOrder.COLOR) {
            WoolVariants variants = this.colorMap.get(color);
            list.add(variants.block());
            list.add(variants.stairs());
            list.add(variants.slab());
            list.add(variants.carpet());
        }
        return list;
    }

    public static class Builder {
        private final String id;
        public class_1767 color;

        public Builder(String id) {
            this.id = id;
        }

        public Builder(String id, class_1767 color) {
            this.id = id;
            this.color = color;
        }

        public WoolBundle register() {
            EnumMap<class_1767, WoolVariants> colorMap = new EnumMap<class_1767, WoolVariants>(class_1767.class);
            for (class_1767 color : BlockOrder.COLOR) {
                String type = color.method_7792() + "_" + this.id;
                class_2248 block = BlockFactory.registerCopy(type, BlockMaps.WOOL_MAP.get(color));
                class_2248 stairs = BlockFactory.stairs(block);
                class_2248 slab = BlockFactory.slab(block);
                class_2248 carpet = BlockFactory.registerCopy(type.replace("wool", "carpet"), settings -> new class_5815(color, settings), BlockMaps.CARPET_MAP.get(color));
                colorMap.put(color, new WoolVariants(block, stairs, slab, carpet));
            }
            WoolBundle bundle = new WoolBundle(colorMap);
            LIST.add(bundle);
            return bundle;
        }
    }

    public record WoolVariants(class_2248 block, class_2248 stairs, class_2248 slab, class_2248 carpet) {
    }
}

