/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.utils.helper;

import com.brand.blockus.Blockus;
import com.brand.blockus.blocks.blockitems.ColoredTilesBlockItem;
import com.brand.blockus.blocks.blockitems.LegacyBlockItem;
import com.brand.blockus.blocks.blockitems.NetherStarBlockItem;
import com.brand.blockus.utils.BlockChecker;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BlockBuilder {
    public static final Function<class_4970.class_2251, class_2248> DEFAULT_FACTORY = class_2248::new;
    public static final Supplier<class_1792.class_1793> DEFAULT_ITEM_SETTINGS = () -> new class_1792.class_1793().method_63685();
    public Function<class_4970.class_2251, class_2248> factory = DEFAULT_FACTORY;
    public class_4970.class_2251 settings;
    public class_1792.class_1793 itemSettings = DEFAULT_ITEM_SETTINGS.get();
    public class_2248 base;

    public BlockBuilder(Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        this.factory = factory;
        this.settings = settings;
    }

    public BlockBuilder(class_4970.class_2251 settings) {
        this.settings = settings;
    }

    public BlockBuilder(class_2248 block) {
        this.settings = class_4970.class_2251.method_9630((class_4970)block);
        this.base = block;
    }

    public BlockBuilder factory(Function<class_4970.class_2251, class_2248> factory) {
        this.factory = factory;
        return this;
    }

    public BlockBuilder settings(class_4970.class_2251 settings) {
        this.settings = settings;
        return this;
    }

    public BlockBuilder settings(Function<class_4970.class_2251, class_4970.class_2251> settingsConsumer) {
        this.settings = settingsConsumer.apply(this.settings);
        return this;
    }

    public BlockBuilder itemSettings(class_1792.class_1793 settings) {
        this.itemSettings = settings;
        return this;
    }

    public BlockBuilder itemSettings(Function<class_1792.class_1793, class_1792.class_1793> settings) {
        this.itemSettings = settings.apply(this.itemSettings);
        return this;
    }

    public BlockBuilder noItem() {
        this.itemSettings = null;
        return this;
    }

    public class_2248 getBase() {
        return this.base;
    }

    public class_2248 register(String id, Function<class_2248, class_1792> itemFactory) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)Blockus.id(id));
        if (this.factory == null) {
            throw new IllegalStateException("Cannot register block: factory is not set!");
        }
        class_2248 block = this.factory.apply(this.settings.method_63500(key));
        class_2378.method_39197((class_2378)class_7923.field_41175, (class_5321)key, (Object)block);
        if (this.itemSettings instanceof class_1792.class_1793) {
            class_5321 itemRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)key.method_29177());
            class_2378.method_39197((class_2378)class_7923.field_41178, (class_5321)itemRegistryKey, (Object)itemFactory.apply(block));
        }
        return block;
    }

    public class_2248 register(String id) {
        return this.register(id, block -> {
            class_5321 itemRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Blockus.id(id));
            class_1792.class_1793 itemSettings = this.itemSettings;
            if (BlockChecker.isNetherite(id) && itemSettings instanceof class_1792.class_1793) {
                class_1792.class_1793 settings = itemSettings;
                itemSettings = settings.method_24359();
            }
            return new class_1747(block, itemSettings.method_63686(itemRegistryKey));
        });
    }

    public class_2248 registerNetherStarBlock(String id) {
        return this.register(id, block -> {
            class_5321 itemRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Blockus.id(id));
            return new NetherStarBlockItem((class_2248)block, this.itemSettings.method_63686(itemRegistryKey).method_7894(class_1814.field_8907));
        });
    }

    public class_2248 registerLegacy(String id, String version) {
        return this.register(id, block -> {
            class_5321 itemRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Blockus.id(id));
            return new LegacyBlockItem((class_2248)block, this.itemSettings.method_63686(itemRegistryKey), version);
        });
    }

    public class_2248 registerColoredTiles(String id) {
        return this.register(id, block -> {
            class_5321 itemRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Blockus.id(id));
            return new ColoredTilesBlockItem((class_2248)block, this.itemSettings.method_63686(itemRegistryKey).method_63684(class_156.method_646((String)"block", (class_2960)Blockus.id("colored_tiles"))));
        });
    }
}

