/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.utils.helper;

import com.brand.blockus.blocks.base.LargeFlowerPotBlock;
import com.brand.blockus.blocks.base.SmallHedgeBlock;
import com.brand.blockus.blocks.base.amethyst.AmethystSlabBlock;
import com.brand.blockus.blocks.base.amethyst.AmethystStairsBlock;
import com.brand.blockus.blocks.base.amethyst.AmethystWallBlock;
import com.brand.blockus.blocks.base.redstone.RedstoneSlabBlock;
import com.brand.blockus.blocks.base.redstone.RedstoneStairsBlock;
import com.brand.blockus.blocks.base.redstone.RedstoneWallBlock;
import com.brand.blockus.utils.BlockChecker;
import com.brand.blockus.utils.helper.BlockBuilder;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2389;
import net.minecraft.class_2440;
import net.minecraft.class_2453;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2504;
import net.minecraft.class_2506;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_8177;

public class BlockFactory {
    public static String replaceId(String id) {
        return id.replace("bricks", "brick").replace("tiles", "tile").replace("_block", "").replace("_planks", "");
    }

    public static class_4970.class_2251 create() {
        return class_4970.class_2251.method_9637();
    }

    public static class_4970.class_2251 createCopy(class_2248 base) {
        return class_4970.class_2251.method_9630((class_4970)base);
    }

    public static BlockBuilder of(Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return new BlockBuilder(factory, settings);
    }

    public static BlockBuilder of(class_4970.class_2251 settings) {
        return new BlockBuilder(settings);
    }

    public static class_2248 registerNoItem(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return BlockFactory.of(factory, settings).noItem().register(id);
    }

    public static class_2248 registerOf(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return BlockFactory.of(factory, settings).register(id);
    }

    public static class_2248 registerOf(String id, class_4970.class_2251 settings) {
        return BlockFactory.of(settings).register(id);
    }

    public static BlockBuilder copy(class_2248 block) {
        return new BlockBuilder(block);
    }

    public static BlockBuilder copy(class_2248 base, Function<class_4970.class_2251, class_4970.class_2251> settings) {
        return BlockFactory.copy(base).settings(settings.apply(class_4970.class_2251.method_9630((class_4970)base)));
    }

    public static class_2248 registerCopy(String id, class_2248 base, Function<class_4970.class_2251, class_4970.class_2251> settings) {
        return BlockFactory.copy(base, settings).register(id);
    }

    public static class_2248 registerCopy(String id, Function<class_4970.class_2251, class_2248> factory, class_2248 base, Function<class_4970.class_2251, class_4970.class_2251> settings) {
        return BlockFactory.copy(base, settings).factory(factory).register(id);
    }

    public static class_2248 registerCopy(String id, class_2248 base) {
        return BlockFactory.copy(base).register(id);
    }

    public static class_2248 registerCopy(String id, Function<class_4970.class_2251, class_2248> factory, class_2248 base) {
        return BlockFactory.copy(base).factory(factory).register(id);
    }

    public static class_2248 pistonProof(String id, class_2248 base) {
        return BlockFactory.copy(base, settings -> settings.method_50012(class_3619.field_15972)).register(id);
    }

    public static BlockBuilder basePillar(class_2248 base) {
        return BlockFactory.copy(base).factory(class_2465::new);
    }

    public static class_2248 pillar(String baseId, class_2248 base) {
        return BlockFactory.basePillar(base).register(BlockFactory.replaceId(baseId) + "_pillar");
    }

    public static class_2248 pillar2(String id, class_2248 base) {
        return BlockFactory.basePillar(base).register(id);
    }

    public static class_2248 pillar(class_2248 base) {
        return BlockFactory.pillar(class_7923.field_41175.method_10221((Object)base).method_12832(), base);
    }

    public static class_2248 slab(String baseId, class_2248 base) {
        String slabId = BlockFactory.replaceId(baseId) + "_slab";
        if (BlockChecker.isAmethyst(baseId)) {
            return BlockFactory.copy(base).factory(AmethystSlabBlock::new).register(slabId);
        }
        if (BlockChecker.isRedstone(baseId)) {
            return BlockFactory.copy(base).factory(RedstoneSlabBlock::new).register(slabId);
        }
        return BlockFactory.copy(base).factory(class_2482::new).register(slabId);
    }

    public static class_2248 slab(class_2248 base) {
        return BlockFactory.slab(class_7923.field_41175.method_10221((Object)base).method_12832(), base);
    }

    public static class_2248 stairs(String baseId, class_2248 base) {
        String stairsId = BlockFactory.replaceId(baseId) + "_stairs";
        if (BlockChecker.isAmethyst(baseId)) {
            return BlockFactory.copy(base).factory(settings -> new AmethystStairsBlock(base.method_9564(), (class_4970.class_2251)settings)).register(stairsId);
        }
        if (BlockChecker.isRedstone(baseId)) {
            return BlockFactory.copy(base).factory(settings -> new RedstoneStairsBlock(base.method_9564(), (class_4970.class_2251)settings)).register(stairsId);
        }
        return BlockFactory.copy(base).factory(settings -> new class_2510(base.method_9564(), settings)).register(stairsId);
    }

    public static class_2248 stairs(class_2248 base) {
        return BlockFactory.stairs(class_7923.field_41175.method_10221((Object)base).method_12832(), base);
    }

    public static class_2248 wall(String baseId, class_2248 base) {
        String wallId = BlockFactory.replaceId(baseId) + "_wall";
        if (BlockChecker.isAmethyst(baseId)) {
            return BlockFactory.copy(base).factory(AmethystWallBlock::new).register(wallId);
        }
        if (BlockChecker.isRedstone(baseId)) {
            return BlockFactory.copy(base).factory(RedstoneWallBlock::new).register(wallId);
        }
        return BlockFactory.copy(base).factory(class_2544::new).register(wallId);
    }

    public static class_2248 wall(class_2248 base) {
        return BlockFactory.wall(class_7923.field_41175.method_10221((Object)base).method_12832(), base);
    }

    public static class_2248 hedge(String id, class_2248 base) {
        return BlockFactory.copy(base).factory(SmallHedgeBlock::new).register(id);
    }

    public static class_4970.class_2251 pressurePlateButtonSettings(class_2248 base) {
        return BlockFactory.create().method_31710(base.method_26403()).method_9632(0.5f).method_51368(base.method_9564().method_51364()).method_9634().method_50012(class_3619.field_15971);
    }

    public static class_2248 pressurePlate(String baseId, class_2248 base, class_8177 blockSetType) {
        return BlockFactory.of(BlockFactory.pressurePlateButtonSettings(base).method_51369()).factory(settings -> new class_2440(blockSetType, settings)).register(BlockFactory.replaceId(baseId) + "_pressure_plate");
    }

    public static class_2248 pressurePlate(class_2248 base, class_8177 blockSetType) {
        return BlockFactory.pressurePlate(class_7923.field_41175.method_10221((Object)base).method_12832(), base, blockSetType);
    }

    public static class_2248 stonePressurePlate(class_2248 base) {
        return BlockFactory.pressurePlate(base, class_8177.field_42821);
    }

    public static class_2248 button(String baseId, class_2248 base, class_8177 blockSetType, int pressTicks) {
        return BlockFactory.of(BlockFactory.pressurePlateButtonSettings(base)).factory(settings -> new class_2269(blockSetType, pressTicks, settings)).register(BlockFactory.replaceId(baseId) + "_button");
    }

    public static class_2248 button(class_2248 base, class_8177 blockSetType, int pressTicks) {
        return BlockFactory.button(class_7923.field_41175.method_10221((Object)base).method_12832(), base, blockSetType, pressTicks);
    }

    public static class_2248 stoneButton(class_2248 base) {
        return BlockFactory.button(base, class_8177.field_42821, 20);
    }

    public static class_4970.class_2251 largeFlowerPotSettings() {
        return BlockFactory.create().method_51368(class_2766.field_12653).method_9629(0.5f, 1.0f).method_50012(class_3619.field_15972).method_22488();
    }

    public static class_2248 pottedPlant(String id, class_2248 content) {
        return BlockFactory.of(BlockFactory.create().method_51368(class_2766.field_12653).method_9618().method_50012(class_3619.field_15971).method_22488()).factory(settings -> new class_2362(content, settings)).noItem().register(id);
    }

    public static class_2248 largePottedPlant(String id, class_2248 content) {
        return BlockFactory.of(BlockFactory.largeFlowerPotSettings()).factory(settings -> new LargeFlowerPotBlock(content, (class_4970.class_2251)settings)).noItem().register(id);
    }

    public static class_2248 largeFlowerPot(String id) {
        return BlockFactory.of(BlockFactory.largeFlowerPotSettings()).factory(settings -> new LargeFlowerPotBlock(class_2246.field_10124, (class_4970.class_2251)settings)).register(id);
    }

    public static class_4970.class_2251 doorTrapdoorBlockSettings(float hardness, float resistance, class_2498 sound, class_3620 color, class_2766 instrument) {
        return BlockFactory.create().method_31710(color).method_51368(instrument).method_9629(hardness, resistance).method_9626(sound).method_22488().method_50012(class_3619.field_15971);
    }

    public static class_2248 woodenDoor(String id, float hardness, float resistance, class_2498 sound, class_3620 color, class_8177 blockSetType) {
        return BlockFactory.of(BlockFactory.doorTrapdoorBlockSettings(hardness, resistance, sound, color, class_2766.field_12651).method_50013()).factory(settings -> new class_2323(blockSetType, settings)).register(id);
    }

    public static class_2248 stoneDoor(String id, float hardness, float resistance, class_2498 sound, class_3620 color, class_8177 blockSetType) {
        return BlockFactory.of(BlockFactory.doorTrapdoorBlockSettings(hardness, resistance, sound, color, class_2766.field_12653).method_29292()).factory(settings -> new class_2323(blockSetType, settings)).register(id);
    }

    public static class_2248 woodenTrapdoor(String id, float hardness, float resistance, class_2498 sound, class_3620 color, class_8177 blockSetType) {
        return BlockFactory.of(BlockFactory.doorTrapdoorBlockSettings(hardness, resistance, sound, color, class_2766.field_12651).method_50013()).factory(settings -> new class_2533(blockSetType, settings)).register(id);
    }

    public static class_2248 stoneTrapdoor(String id, float hardness, float resistance, class_2498 sound, class_3620 color, class_8177 blockSetType) {
        return BlockFactory.of(BlockFactory.doorTrapdoorBlockSettings(hardness, resistance, sound, color, class_2766.field_12653).method_29292()).factory(settings -> new class_2533(blockSetType, settings)).register(id);
    }

    public static class_2248 lampBlock(String id, float hardness, float resistance, class_2498 sound, int luminance, class_3620 color) {
        return BlockFactory.of(BlockFactory.create().method_31710(color).method_9629(hardness, resistance).method_9626(sound).method_9631(state -> luminance)).register(id);
    }

    public static class_2248 neonBlock(String id, class_1767 color) {
        return BlockFactory.of(BlockFactory.create().method_51517(color).method_9631(state -> 2).method_9626(class_2498.field_11537).method_9629(0.5f, 0.5f).method_26249(BlockFactory::always).method_26235(BlockFactory::never)).register(id);
    }

    public static class_2248 neonBlock(class_1767 color) {
        return BlockFactory.of(BlockFactory.create().method_51517(color).method_9631(state -> 2).method_9626(class_2498.field_11537).method_9629(0.5f, 0.5f).method_26249(BlockFactory::always).method_26235(BlockFactory::never)).getBase();
    }

    public static class_2248 redstoneLamp(String id, class_3620 mapColor) {
        return BlockFactory.registerCopy(id, class_2453::new, class_2246.field_10524, settings -> settings.method_31710(mapColor).method_26235(BlockFactory::always));
    }

    public static class_2248 litRedstoneLamp(String id, class_2248 base) {
        return BlockFactory.registerCopy(id, base, (class_4970.class_2251 settings) -> settings.method_9631(state -> 15).method_26235(BlockFactory::always));
    }

    public static class_2248 futurneoBlock(String id, class_3620 color) {
        return BlockFactory.of(BlockFactory.create().method_31710(color).method_9631(state -> 15).method_9629(0.5f, 0.5f).method_9626(class_2498.field_11537).method_26235(BlockFactory::always)).register(id);
    }

    public static class_2248 stainedGlass(String id, class_1767 color, class_2248 base) {
        return BlockFactory.copy(base, settings -> settings.method_26235(BlockFactory::never).method_26236(BlockFactory::never).method_26243(BlockFactory::never).method_26245(BlockFactory::never)).factory(settings -> new class_2506(color, settings)).register(id);
    }

    public static class_2248 stainedGlassPane(String id, class_1767 color, class_2248 base) {
        return BlockFactory.copy(base).factory(settings -> new class_2504(color, settings)).register(id);
    }

    public static class_2248 woodenPane(String id) {
        return BlockFactory.registerOf(id, class_2389::new, BlockFactory.create().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(0.1f, 0.8f).method_9626(class_2498.field_11547).method_50013());
    }

    public static class_4970.class_2251 crateSettings() {
        return BlockFactory.create().method_31710(class_2246.field_10161.method_26403()).method_9632(2.5f).method_51368(class_2766.field_12651).method_9626(class_2498.field_11547);
    }

    public static class_2248 crate(String id) {
        return BlockFactory.registerOf(id, BlockFactory.crateSettings());
    }

    public static class_2248 crate(String id, int luminance) {
        return BlockFactory.registerOf(id, BlockFactory.crateSettings().method_9631(state -> luminance));
    }

    public static class_2248 registerNetherStarBlock(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return new BlockBuilder(factory, settings).registerNetherStarBlock(id);
    }

    public static class_2248 registerLegacy(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, String version) {
        BlockBuilder builder = factory == null ? new BlockBuilder(settings) : new BlockBuilder(factory, settings);
        return builder.registerLegacy(id, version);
    }

    public static class_2248 registerLegacy(String id, class_4970.class_2251 settings, String version) {
        return BlockFactory.registerLegacy(id, null, settings, version);
    }

    public static boolean always(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    public static Boolean always(class_2680 state, class_1922 world, class_2338 pos, class_1299<?> type) {
        return true;
    }

    public static boolean never(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    public static Boolean never(class_2680 state, class_1922 world, class_2338 pos, class_1299<?> type) {
        return false;
    }

    public static Boolean canSpawnOnLeaves(class_2680 state, class_1922 world, class_2338 pos, class_1299<?> type) {
        return type == class_1299.field_6081 || type == class_1299.field_6104;
    }
}

