/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.datagen.providers;

import com.brand.blockus.Blockus;
import com.brand.blockus.blocks.base.PostBlock;
import com.brand.blockus.datagen.family.BlockusFamilies;
import com.brand.blockus.datagen.models.BlockusModels;
import com.brand.blockus.datagen.models.BlockusTextureKey;
import com.brand.blockus.registry.content.BlockusBlocks;
import com.brand.blockus.registry.content.BlockusEntities;
import com.brand.blockus.registry.content.bundles.AsphaltBundle;
import com.brand.blockus.registry.content.bundles.BSSWBundle;
import com.brand.blockus.registry.content.bundles.ColoredTilesBundle;
import com.brand.blockus.registry.content.bundles.ConcreteBundle;
import com.brand.blockus.registry.content.bundles.CopperBundle;
import com.brand.blockus.registry.content.bundles.PottedLargeBundle;
import com.brand.blockus.registry.content.bundles.TimberFrameBundle;
import com.brand.blockus.registry.content.bundles.WoodenPostBundle;
import com.brand.blockus.registry.content.bundles.WoolBundle;
import com.brand.blockus.utils.Properties;
import com.brand.blockus.utils.helper.BlockOrder;
import com.brand.blockus.utils.helper.WoodMaps;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10410;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5794;
import net.minecraft.class_7923;
import net.minecraft.class_807;

public class BlockusModelProvider
extends FabricModelProvider {
    public BlockusModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 modelGenerator) {
        BlockusFamilies.getFamilies().filter(class_5794::method_33477).forEach(family -> modelGenerator.method_25650(family.method_33469()).method_33522(family));
        for (BSSWBundle bSSWBundle : BSSWBundle.values()) {
            if (bSSWBundle.type().contains("rough") && bSSWBundle.type().contains("sandstone")) {
                this.registerBlockStairsSlabWithBottom(modelGenerator, bSSWBundle.block(), bSSWBundle.stairs(), bSSWBundle.slab(), bSSWBundle.base());
            } else if (bSSWBundle.type().contains("smooth") && bSSWBundle.type().contains("sandstone") || bSSWBundle.block() == BlockusBlocks.ROUGH_BASALT.block()) {
                this.registerBlockStairsSlabWithTop(modelGenerator, bSSWBundle.block(), bSSWBundle.stairs(), bSSWBundle.slab(), bSSWBundle.base());
            } else if (bSSWBundle.block() == BlockusBlocks.SOUL_SANDSTONE.block()) {
                this.registerBlockStairsSlabwithTopBottom(modelGenerator, bSSWBundle.block(), bSSWBundle.stairs(), bSSWBundle.slab());
            } else {
                this.registerBlockStairsAndSlab(modelGenerator, bSSWBundle.block(), bSSWBundle.stairs(), bSSWBundle.slab());
            }
            if (bSSWBundle.wall() == null) continue;
            this.registerWall(modelGenerator, bSSWBundle.wall(), bSSWBundle.block());
        }
        for (ConcreteBundle concreteBundle : ConcreteBundle.values()) {
            for (ConcreteBundle.ConcreteVariants concreteVariants : concreteBundle.colorMap().values()) {
                this.registerBlockStairsSlabAndWall(modelGenerator, concreteVariants.block(), concreteVariants.stairs(), concreteVariants.slab(), concreteVariants.wall());
                modelGenerator.method_25641(concreteVariants.chiseled());
                this.registerPillar(modelGenerator, concreteVariants.pillar());
            }
        }
        for (AsphaltBundle.AsphaltVariants asphaltVariants : BlockusBlocks.ASPHALT.colorMap().values()) {
            this.registerBlockStairsAndSlab(modelGenerator, asphaltVariants.block(), asphaltVariants.stairs(), asphaltVariants.slab());
        }
        for (WoolBundle woolBundle : WoolBundle.values()) {
            for (WoolBundle.WoolVariants woolVariants : woolBundle.colorMap().values()) {
                this.registerBlockStairsAndSlab(modelGenerator, woolVariants.block(), woolVariants.stairs(), woolVariants.slab());
                this.registerCarpet(modelGenerator, woolVariants.block(), woolVariants.carpet());
            }
        }
        for (ColoredTilesBundle coloredTilesBundle : ColoredTilesBundle.values()) {
            BlockusModelProvider.registerColoredTiles(modelGenerator, coloredTilesBundle.block(), coloredTilesBundle.tile1(), coloredTilesBundle.tile2());
        }
        for (PottedLargeBundle pottedLargeBundle : PottedLargeBundle.values()) {
            modelGenerator.method_25681(pottedLargeBundle.block());
        }
        modelGenerator.method_25681(BlockusBlocks.LARGE_FLOWER_POT);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.COPPER_BRICKS, BlockusFamilies.COPPER_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.EXPOSED_COPPER_BRICKS, BlockusFamilies.EXPOSED_COPPER_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.WEATHERED_COPPER_BRICKS, BlockusFamilies.WEATHERED_COPPER_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.OXIDIZED_COPPER_BRICKS, BlockusFamilies.OXIDIZED_COPPER_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.COPPER_TUFF_BRICKS, BlockusFamilies.COPPER_TUFF_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.EXPOSED_COPPER_TUFF_BRICKS, BlockusFamilies.EXPOSED_COPPER_TUFF_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.WEATHERED_COPPER_TUFF_BRICKS, BlockusFamilies.WEATHERED_COPPER_TUFF_BRICKS);
        this.registerCopperBlocks(modelGenerator, BlockusBlocks.OXIDIZED_COPPER_TUFF_BRICKS, BlockusFamilies.OXIDIZED_COPPER_TUFF_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.STONE_BRICK_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_STONE_BRICKS);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.STONE_CIRCULAR_PAVING});
        modelGenerator.method_25658(BlockusBlocks.STONE_DOOR);
        modelGenerator.method_25665(BlockusBlocks.STONE_TRAPDOOR);
        this.registerSturdyStone(modelGenerator);
        this.registerSmoothStoneStairs(modelGenerator);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.ANDESITE_CIRCULAR_PAVING});
        modelGenerator.method_25641(BlockusBlocks.CHISELED_ANDESITE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_ANDESITE_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.POLISHED_ANDESITE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_ANDESITE_PRESSURE_PLATE, BlockusBlocks.POLISHED_ANDESITE_BUTTON, class_2246.field_10093);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_ANDESITE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_DIORITE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_DIORITE_BRICKS);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.DIORITE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.POLISHED_DIORITE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_DIORITE_PRESSURE_PLATE, BlockusBlocks.POLISHED_DIORITE_BUTTON, class_2246.field_10346);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_DIORITE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_GRANITE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_GRANITE_BRICKS);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.GRANITE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.POLISHED_GRANITE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_GRANITE_PRESSURE_PLATE, BlockusBlocks.POLISHED_GRANITE_BUTTON, class_2246.field_10289);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_GRANITE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_MUD_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.MUD_BRICK_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_DRIPSTONE);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_DRIPSTONE_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.DRIPSTONE_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.CARVED_TUFF_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_TUFF_BRICKS);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_TUFF_PRESSURE_PLATE, BlockusBlocks.POLISHED_TUFF_BUTTON, class_2246.field_47030);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.TUFF_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.TUFF_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_TUFF_BRICKS);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.DEEPSLATE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.DEEPSLATE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_DEEPSLATE_PRESSURE_PLATE, BlockusBlocks.POLISHED_DEEPSLATE_BUTTON, class_2246.field_28892);
        modelGenerator.method_25641(BlockusBlocks.STURDY_DEEPSLATE);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_DEEPSLATE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_SCULK_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.SCULK_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_SCULK_PRESSURE_PLATE, BlockusBlocks.POLISHED_SCULK_BUTTON, BlockusBlocks.POLISHED_SCULK.block());
        modelGenerator.method_25641(BlockusBlocks.CHISELED_AMETHYST);
        this.registerPillar(modelGenerator, BlockusBlocks.AMETHYST_PILLAR);
        this.registerAmethystLamp(modelGenerator);
        modelGenerator.method_25665(BlockusBlocks.BLACKSTONE_TRAPDOOR);
        this.registerCubeColumnNoSuffix(modelGenerator, BlockusBlocks.GOLD_DECORATED_POLISHED_BLACKSTONE, class_2246.field_23873);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.POLISHED_BLACKSTONE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.POLISHED_BLACKSTONE_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.STURDY_BLACKSTONE);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_POLISHED_BLACKSTONE_BRICKS);
        modelGenerator.method_25658(BlockusBlocks.BLACKSTONE_DOOR);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_POLISHED_BASALT);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_POLISHED_BASALT_BRICKS);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.POLISHED_BASALT_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.POLISHED_BASALT_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_BASALT_PRESSURE_PLATE, BlockusBlocks.POLISHED_BASALT_BUTTON, class_4944.method_25866((class_2248)class_2246.field_23151, (String)"_top"));
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_POLISHED_BASALT_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_LIMESTONE);
        this.registerAxisRotatedCubeColumn(modelGenerator, BlockusBlocks.CHISELED_LIMESTONE_BRICKS, BlockusBlocks.POLISHED_LIMESTONE.block());
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.LIMESTONE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.LIMESTONE_PILLAR);
        this.registerPillar(modelGenerator, BlockusBlocks.CHISELED_LIMESTONE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.LIMESTONE_PRESSURE_PLATE, BlockusBlocks.LIMESTONE_BUTTON, BlockusBlocks.LIMESTONE.block());
        modelGenerator.method_25641(BlockusBlocks.LIMESTONE_SQUARES);
        this.registerLines(modelGenerator, BlockusBlocks.LIMESTONE_LINES);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_MARBLE);
        this.registerAxisRotatedCubeColumn(modelGenerator, BlockusBlocks.CHISELED_MARBLE_BRICKS, BlockusBlocks.POLISHED_MARBLE.block());
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.MARBLE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.MARBLE_PILLAR);
        this.registerPillar(modelGenerator, BlockusBlocks.CHISELED_MARBLE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.MARBLE_PRESSURE_PLATE, BlockusBlocks.MARBLE_BUTTON, BlockusBlocks.MARBLE.block());
        modelGenerator.method_25641(BlockusBlocks.MARBLE_SQUARES);
        this.registerLines(modelGenerator, BlockusBlocks.MARBLE_LINES);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.BLUESTONE_CIRCULAR_PAVING});
        this.registerLines(modelGenerator, BlockusBlocks.BLUESTONE_LINES);
        this.registerPillar(modelGenerator, BlockusBlocks.BLUESTONE_PILLAR);
        this.registerPillar(modelGenerator, BlockusBlocks.CHISELED_BLUESTONE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.BLUESTONE_PRESSURE_PLATE, BlockusBlocks.BLUESTONE_BUTTON, BlockusBlocks.BLUESTONE.block());
        modelGenerator.method_25641(BlockusBlocks.BLUESTONE_SQUARES);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_BLUESTONE);
        this.registerAxisRotatedCubeColumn(modelGenerator, BlockusBlocks.CHISELED_BLUESTONE_BRICKS, BlockusBlocks.POLISHED_BLUESTONE.block());
        modelGenerator.method_25641(BlockusBlocks.CHISELED_VIRIDITE);
        this.registerAxisRotatedCubeColumn(modelGenerator, BlockusBlocks.CHISELED_VIRIDITE_BRICKS, BlockusBlocks.POLISHED_VIRIDITE.block());
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.VIRIDITE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.VIRIDITE_PILLAR);
        this.registerPillar(modelGenerator, BlockusBlocks.CHISELED_VIRIDITE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.VIRIDITE_PRESSURE_PLATE, BlockusBlocks.VIRIDITE_BUTTON, BlockusBlocks.VIRIDITE.block());
        modelGenerator.method_25641(BlockusBlocks.VIRIDITE_SQUARES);
        this.registerLines(modelGenerator, BlockusBlocks.VIRIDITE_LINES);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_LAVA_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_LAVA_POLISHED_BLACKSTONE);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_WATER_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.SNOW_PILLAR);
        modelGenerator.method_25650(BlockusBlocks.ICE_BRICKS).method_25720(BlockusBlocks.ICE_BRICK_WALL);
        this.registerPillar(modelGenerator, BlockusBlocks.ICE_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_OBSIDIAN_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.GLOWING_OBSIDIAN);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.OBSIDIAN_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.OBSIDIAN_PILLAR);
        modelGenerator.method_25665(BlockusBlocks.OBSIDIAN_REINFORCED_TRAPDOOR);
        modelGenerator.method_25658(BlockusBlocks.OBSIDIAN_REINFORCED_DOOR);
        this.registerPressurePlate(modelGenerator, BlockusBlocks.OBSIDIAN_PRESSURE_PLATE, class_4944.method_25860((class_2248)class_2246.field_10540));
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.NETHERRACK_CIRCULAR_PAVING});
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_NETHERRACK_PRESSURE_PLATE, BlockusBlocks.POLISHED_NETHERRACK_BUTTON, BlockusBlocks.POLISHED_NETHERRACK.block());
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.QUARTZ_CIRCULAR_PAVING});
        modelGenerator.method_25641(BlockusBlocks.CHISELED_MAGMA_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.BLAZE_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.BLAZE_LANTERN);
        this.registerPillar(modelGenerator, BlockusBlocks.NETHER_BRICK_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_NETHER_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.RED_NETHER_BRICK_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_RED_NETHER_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.CHARRED_NETHER_BRICK_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_CHARRED_NETHER_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.TEAL_NETHER_BRICK_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_TEAL_NETHER_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_DARK_PRISMARINE);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_PRISMARINE);
        this.registerPillar(modelGenerator, BlockusBlocks.DARK_PRISMARINE_PILLAR);
        modelGenerator.method_25614(class_4946.field_23045, new class_2248[]{BlockusBlocks.PRISMARINE_CIRCULAR_PAVING});
        this.registerPillar(modelGenerator, BlockusBlocks.PRISMARINE_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_SOAKED_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_CHARRED_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_SANDY_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_RESIN_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.RESIN_BRICK_PILLAR);
        this.registerPillar(modelGenerator, BlockusBlocks.SANDSTONE_PILLAR);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.GOLD_DECORATED_SANDSTONE, class_2246.field_9979);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.LAPIS_DECORATED_SANDSTONE, class_2246.field_9979);
        this.registerPillar(modelGenerator, BlockusBlocks.RED_SANDSTONE_PILLAR);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.GOLD_DECORATED_RED_SANDSTONE, class_2246.field_10344);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.LAPIS_DECORATED_RED_SANDSTONE, class_2246.field_10344);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.CHISELED_SOUL_SANDSTONE, BlockusBlocks.SOUL_SANDSTONE.block());
        this.registerCubeColumn(modelGenerator, BlockusBlocks.CUT_SOUL_SANDSTONE, BlockusBlocks.SOUL_SANDSTONE.block());
        this.registerSlabwithTop(modelGenerator, BlockusBlocks.CUT_SOUL_SANDSTONE_SLAB, BlockusBlocks.CUT_SOUL_SANDSTONE, BlockusBlocks.SOUL_SANDSTONE.block());
        this.registerPillar(modelGenerator, BlockusBlocks.SOUL_SANDSTONE_PILLAR);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.GOLD_DECORATED_SOUL_SANDSTONE, BlockusBlocks.SOUL_SANDSTONE.block());
        this.registerCubeColumn(modelGenerator, BlockusBlocks.LAPIS_DECORATED_SOUL_SANDSTONE, BlockusBlocks.SOUL_SANDSTONE.block());
        modelGenerator.method_49378(BlockusBlocks.RAINBOW_PETALS);
        this.registerUpDefaultFacingBlock(modelGenerator, BlockusBlocks.RAINBOW_BLOCK);
        this.registerTopBottomFacingBottom(modelGenerator, BlockusBlocks.RAINBOW_ASPHALT);
        this.registerFlowerPotPlantAndItem(modelGenerator, BlockusBlocks.RAINBOW_ROSE, BlockusBlocks.POTTED_RAINBOW_ROSE, class_4910.class_4913.field_22840);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_PURPUR);
        modelGenerator.method_25622(BlockusBlocks.PURPUR_DECORATED_END_STONE, class_4946.field_23055);
        this.registerLines(modelGenerator, BlockusBlocks.PURPUR_LINES);
        modelGenerator.method_25641(BlockusBlocks.PURPUR_SQUARES);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_PHANTOM_PURPUR);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.PHANTOM_PURPUR_DECORATED_END_STONE, BlockusBlocks.PURPUR_DECORATED_END_STONE);
        this.registerLines(modelGenerator, BlockusBlocks.PHANTOM_PURPUR_LINES);
        this.registerPillar(modelGenerator, BlockusBlocks.PHANTOM_PURPUR_PILLAR);
        modelGenerator.method_25641(BlockusBlocks.PHANTOM_PURPUR_SQUARES);
        modelGenerator.method_25641(BlockusBlocks.CHISELED_END_STONE_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.CRACKED_END_STONE_BRICKS);
        this.registerPillar(modelGenerator, BlockusBlocks.END_STONE_PILLAR);
        this.registerButtonAndPressurePlate(modelGenerator, BlockusBlocks.POLISHED_END_STONE_PRESSURE_PLATE, BlockusBlocks.POLISHED_END_STONE_BUTTON, BlockusBlocks.POLISHED_END_STONE.block());
        modelGenerator.method_25641(BlockusBlocks.HERRINGBONE_END_STONE_BRICKS);
        modelGenerator.method_25676(BlockusBlocks.WHITE_OAK_LOG).method_25730(BlockusBlocks.WHITE_OAK_LOG).method_25728(BlockusBlocks.WHITE_OAK_WOOD);
        modelGenerator.method_25622(BlockusBlocks.WHITE_OAK_LEAVES, class_4946.field_23049);
        modelGenerator.method_25676(BlockusBlocks.STRIPPED_WHITE_OAK_LOG).method_25730(BlockusBlocks.STRIPPED_WHITE_OAK_LOG).method_25728(BlockusBlocks.STRIPPED_WHITE_OAK_WOOD);
        this.registerFlowerPotPlantAndItem(modelGenerator, BlockusBlocks.WHITE_OAK_SAPLING, BlockusBlocks.POTTED_WHITE_OAK_SAPLING, class_4910.class_4913.field_22840);
        modelGenerator.method_46190(BlockusBlocks.WHITE_OAK_LOG, BlockusBlocks.WHITE_OAK.ceilingHangingSign(), BlockusBlocks.WHITE_OAK.wallHangingSign());
        modelGenerator.method_46190(BlockusBlocks.RAW_BAMBOO.planks(), BlockusBlocks.RAW_BAMBOO.ceilingHangingSign(), BlockusBlocks.RAW_BAMBOO.wallHangingSign());
        modelGenerator.method_46190(BlockusBlocks.CHARRED.planks(), BlockusBlocks.CHARRED.ceilingHangingSign(), BlockusBlocks.CHARRED.wallHangingSign());
        for (class_2248 class_22482 : BlockusBlocks.HERRINGBONE_PLANKS.bundle().values()) {
            modelGenerator.method_25641(class_22482);
        }
        for (class_2248 class_22483 : BlockusBlocks.SMALL_LOGS.bundle().values()) {
            this.registerAxisRotatedCubeColumn(modelGenerator, class_22483);
        }
        for (Map.Entry entry : BlockusBlocks.WOODEN_POST.woodMap().entrySet()) {
            this.registerPost(modelGenerator, ((WoodenPostBundle.WoodenPostVariants)entry.getValue()).block(), WoodMaps.LOG_MAP.get(((WoodMaps)((Object)entry.getKey())).getId()));
            this.registerPost(modelGenerator, ((WoodenPostBundle.WoodenPostVariants)entry.getValue()).stripped(), WoodMaps.STRIPPED_LOG_MAP.get(((WoodMaps)((Object)entry.getKey())).getId()));
        }
        for (Map.Entry entry : BlockusBlocks.TIMBER_FRAME.woodMap().entrySet()) {
            modelGenerator.method_25641(((TimberFrameBundle.TimberFrameVariants)entry.getValue()).block());
            modelGenerator.method_25641(((TimberFrameBundle.TimberFrameVariants)entry.getValue()).cross());
            this.registerDiagonalTimberFrame(modelGenerator, ((TimberFrameBundle.TimberFrameVariants)entry.getValue()).diagonal());
            modelGenerator.method_25651(((TimberFrameBundle.TimberFrameVariants)entry.getValue()).grate(), ((TimberFrameBundle.TimberFrameVariants)entry.getValue()).lattice());
        }
        this.registerSmallHedge(modelGenerator, BlockusBlocks.OAK_HEDGE, class_2246.field_10503, -12012264);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.SPRUCE_HEDGE, class_2246.field_9988, -10380959);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.BIRCH_HEDGE, class_2246.field_10539, -8345771);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.JUNGLE_HEDGE, class_2246.field_10335, -12012264);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.ACACIA_HEDGE, class_2246.field_10098, -12012264);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.DARK_OAK_HEDGE, class_2246.field_10035, -12012264);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.MANGROVE_HEDGE, class_2246.field_37551, -7158200);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.CHERRY_HEDGE, class_2246.field_42731);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.PALE_OAK_HEDGE, class_2246.field_54714);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.WARPED_HEDGE, class_2246.field_22115);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.CRIMSON_HEDGE, class_2246.field_10541);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.WHITE_OAK_HEDGE, BlockusBlocks.WHITE_OAK_LEAVES);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.AZALEA_HEDGE, class_2246.field_28673);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.FLOWERING_AZALEA_HEDGE, class_2246.field_28674);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.MOSS_HEDGE, class_2246.field_28681);
        this.registerSmallHedge(modelGenerator, BlockusBlocks.PALE_MOSS_HEDGE, class_2246.field_54731);
        this.registerFishCrate(modelGenerator, BlockusBlocks.COD_CRATE);
        this.registerFishCrate(modelGenerator, BlockusBlocks.PUFFERFISH_CRATE);
        this.registerFishCrate(modelGenerator, BlockusBlocks.SALMON_CRATE);
        this.registerFishCrate(modelGenerator, BlockusBlocks.TROPICAL_FISH_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.SWEET_BERRIES_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.GLOW_BERRIES_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.POTATO_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.APPLE_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.GOLDEN_APPLE_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.BEETROOT_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.CARROT_CRATE);
        this.registerCrate(modelGenerator, BlockusBlocks.GOLDEN_CARROT_CRATE);
        this.registerBreadBox(modelGenerator, BlockusBlocks.BREAD_BOX);
        this.registerAxisRotatedCubeColumn(modelGenerator, BlockusBlocks.CHORUS_BLOCK);
        this.registerCookieBlock(modelGenerator);
        this.registerDirectionalCarpet(modelGenerator, BlockusBlocks.CHOCOLATE_SQUARES, BlockusBlocks.CHOCOLATE_TABLET);
        modelGenerator.method_25641(BlockusBlocks.CHOCOLATE_SQUARES);
        this.registerLitRedstoneLamp(modelGenerator, class_2246.field_10524, BlockusBlocks.REDSTONE_LAMP_LIT);
        this.registerRedstoneLamp(modelGenerator, BlockusBlocks.RAINBOW_LAMP, BlockusBlocks.RAINBOW_LAMP_LIT);
        for (Iterator<Object> iterator : BlockOrder.COLOR) {
            this.registerRedstoneLamp(modelGenerator, BlockusBlocks.STAINED_REDSTONE_LAMP.colorMap().get(iterator), BlockusBlocks.STAINED_REDSTONE_LAMP_LIT.colorMap().get(iterator));
        }
        for (class_2248 class_22484 : BlockusBlocks.NEON_BLOCK.colorMap().values()) {
            this.registerNeonBlock(modelGenerator, class_22484);
        }
        this.registerNeonBlock(modelGenerator, BlockusBlocks.RAINBOW_NEON);
        for (class_2248 class_22485 : BlockusBlocks.FUTURNEO_BLOCK.colorMap().values()) {
            modelGenerator.method_25641(class_22485);
        }
        modelGenerator.method_25641(BlockusBlocks.GRAY_BRIGHT_FUTURNEO_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.RAINBOW_FUTURNEO_BLOCK);
        this.registerBeveledGlassPane(modelGenerator, BlockusBlocks.RAINBOW_BEVELED_GLASS, BlockusBlocks.RAINBOW_BEVELED_GLASS_PANE);
        modelGenerator.method_25651(BlockusBlocks.RAINBOW_GLASS, BlockusBlocks.RAINBOW_GLASS_PANE);
        this.registerBeveledGlassPane(modelGenerator, BlockusBlocks.BEVELED_GLASS, BlockusBlocks.BEVELED_GLASS_PANE);
        for (Iterator<Object> iterator : BlockOrder.COLOR) {
            this.registerBeveledGlassPane(modelGenerator, BlockusBlocks.STAINED_BEVELED_GLASS.colorMap().get(iterator), BlockusBlocks.STAINED_BEVELED_GLASS_PANE.colorMap().get(iterator));
        }
        modelGenerator.method_25641(BlockusBlocks.TINTED_BEVELED_GLASS);
        for (class_2248 class_22486 : BlockusBlocks.GLAZED_TERRACOTTA_PILLAR.colorMap().values()) {
            this.registerPillar(modelGenerator, class_22486);
        }
        modelGenerator.method_25641(BlockusBlocks.BURNT_PAPER_BLOCK);
        modelGenerator.method_25651(BlockusBlocks.FRAMED_PAPER_BLOCK, BlockusBlocks.PAPER_WALL);
        modelGenerator.method_25641(BlockusBlocks.PAPER_BLOCK);
        modelGenerator.method_25665(BlockusBlocks.PAPER_TRAPDOOR);
        modelGenerator.method_25658(BlockusBlocks.PAPER_DOOR);
        modelGenerator.method_25681(BlockusBlocks.PAPER_LAMP);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.LANTERN_BLOCK, BlockusBlocks.LANTERN_BLOCK);
        modelGenerator.method_25706(BlockusBlocks.AMETHYST_LANTERN);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.AMETHYST_LANTERN_BLOCK, BlockusBlocks.LANTERN_BLOCK);
        modelGenerator.method_25706(BlockusBlocks.REDSTONE_LANTERN);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.REDSTONE_LANTERN_BLOCK, BlockusBlocks.LANTERN_BLOCK);
        this.registerCubeColumn(modelGenerator, BlockusBlocks.SOUL_LANTERN_BLOCK, BlockusBlocks.LANTERN_BLOCK);
        this.registerPumpkins(modelGenerator, BlockusBlocks.SOUL_O_LANTERN);
        this.registerPumpkins(modelGenerator, BlockusBlocks.REDSTONE_O_LANTERN);
        this.registerLegacyStonecutter(modelGenerator, BlockusBlocks.LEGACY_STONECUTTER);
        modelGenerator.method_25622(BlockusBlocks.LEGACY_LEAVES, class_4946.field_23049);
        this.registerFlowerPotPlantAndItem(modelGenerator, BlockusBlocks.LEGACY_SAPLING, BlockusBlocks.POTTED_LEGACY_SAPLING, class_4910.class_4913.field_22840);
        this.registerAxisRotatedCubeColumn(modelGenerator, BlockusBlocks.LEGACY_LOG);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_NETHER_REACTOR_CORE);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_PLANKS);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_BRICKS);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_COBBLESTONE);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_FIRST_COBBLESTONE);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_MOSSY_COBBLESTONE);
        this.registerCubeBottomTop(modelGenerator, BlockusBlocks.LEGACY_GRASS_BLOCK, class_2246.field_10566);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_FIRST_GRASS_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_GRAVEL);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_COAL_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_LAPIS_BLOCK);
        this.registerCubeBottomTop(modelGenerator, BlockusBlocks.LEGACY_IRON_BLOCK);
        this.registerCubeBottomTop(modelGenerator, BlockusBlocks.LEGACY_GOLD_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_EXPLOSION_PROOF_GOLD_BLOCK);
        this.registerCubeBottomTop(modelGenerator, BlockusBlocks.LEGACY_DIAMOND_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_SPONGE);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_CRYING_OBSIDIAN);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_GLOWING_OBSIDIAN);
        modelGenerator.method_25641(BlockusBlocks.LEGACY_GLOWSTONE);
        this.registerFlowerPotPlantAndItem(modelGenerator, BlockusBlocks.LEGACY_ROSE, BlockusBlocks.POTTED_LEGACY_ROSE, class_4910.class_4913.field_22840);
        this.registerFlowerPotPlantAndItem(modelGenerator, BlockusBlocks.LEGACY_BLUE_ROSE, BlockusBlocks.POTTED_LEGACY_BLUE_ROSE, class_4910.class_4913.field_22840);
        modelGenerator.method_25641(BlockusBlocks.RAINBOW_COLORED_TILES);
        for (Iterator<Object> iterator : BlockOrder.COLOR) {
            this.registerColoredTilesSimple(modelGenerator, BlockusBlocks.COLORED_TILES.colorMap().get(iterator));
        }
        this.registerStairsAndSlab(modelGenerator, BlockusBlocks.NETHERITE_STAIRS, BlockusBlocks.NETHERITE_SLAB, class_2246.field_22108);
        modelGenerator.method_25641(BlockusBlocks.NETHER_STAR_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.RAINBOW_GLOWSTONE);
        modelGenerator.method_25641(BlockusBlocks.CAUTION_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.CHARCOAL_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.COMPANION_CUBE);
        modelGenerator.method_25641(BlockusBlocks.ENDER_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.LOVE_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.MEMBRANE_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.REDSTONE_SAND);
        modelGenerator.method_25641(BlockusBlocks.ROTTEN_FLESH_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.STARS_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.SUGAR_BLOCK);
        modelGenerator.method_25641(BlockusBlocks.WEIGHT_STORAGE_CUBE);
        modelGenerator.method_25537(BlockusBlocks.GOLDEN_CHAIN.method_8389());
        modelGenerator.method_25600(BlockusBlocks.GOLDEN_BARS);
        modelGenerator.method_25600(BlockusBlocks.WOODEN_FRAME);
        modelGenerator.method_25537(BlockusBlocks.IRON_GATE.method_8389());
        modelGenerator.method_25537(BlockusBlocks.GOLDEN_GATE.method_8389());
        this.registerInventoryItemModel(modelGenerator, BlockusBlocks.CAUTION_BARRIER);
        this.registerInventoryItemModel(modelGenerator, BlockusBlocks.ROAD_BARRIER);
        modelGenerator.method_25623(BlockusBlocks.PATH, class_4941.method_25843((class_2248)BlockusBlocks.PATH, (String)"4"));
    }

    public void generateItemModels(class_4915 modelGenerator) {
        modelGenerator.method_65442(BlockusEntities.CHARRED_BOAT.method_8389(), class_4943.field_22938);
        modelGenerator.method_65442(BlockusEntities.CHARRED_CHEST_BOAT.method_8389(), class_4943.field_22938);
        modelGenerator.method_65442(BlockusEntities.RAW_BAMBOO_RAFT.method_8389(), class_4943.field_22938);
        modelGenerator.method_65442(BlockusEntities.RAW_BAMBOO_CHEST_RAFT.method_8389(), class_4943.field_22938);
        modelGenerator.method_65442(BlockusEntities.WHITE_OAK_BOAT.method_8389(), class_4943.field_22938);
        modelGenerator.method_65442(BlockusEntities.WHITE_OAK_CHEST_BOAT.method_8389(), class_4943.field_22938);
    }

    public final void registerInventoryItemModel(class_4910 modelGenerator, class_2248 block) {
        modelGenerator.method_25623(block, class_4941.method_25843((class_2248)block, (String)"_inventory"));
    }

    public final void registerPillar(class_4910 modelGenerator, class_2248 block) {
        modelGenerator.method_25554(block, class_4946.field_23055, class_4946.field_23056);
    }

    public final void registerLines(class_4910 modelGenerator, class_2248 block) {
        modelGenerator.method_25553(block, class_4946.field_23036);
    }

    public final void registerBlockStairsSlabAndWall(class_4910 modelGenerator, class_2248 block, class_2248 stairs, class_2248 slab, class_2248 wall) {
        modelGenerator.method_25650(block).method_25725(stairs).method_25724(slab).method_25720(wall);
    }

    public final void registerBlockStairsAndSlab(class_4910 modelGenerator, class_2248 block, class_2248 stairs, class_2248 slab) {
        modelGenerator.method_25650(block).method_25725(stairs).method_25724(slab);
    }

    public final void registerButtonAndPressurePlate(class_4910 modelGenerator, class_2248 pressurePlateBlock, class_2248 buttonBlock, class_2248 textureID) {
        this.registerButton(modelGenerator, buttonBlock, class_4944.method_25860((class_2248)textureID));
        this.registerPressurePlate(modelGenerator, pressurePlateBlock, class_4944.method_25860((class_2248)textureID));
    }

    public final void registerButtonAndPressurePlate(class_4910 modelGenerator, class_2248 pressurePlateBlock, class_2248 buttonBlock, class_2960 textureSource) {
        this.registerButton(modelGenerator, buttonBlock, textureSource);
        this.registerPressurePlate(modelGenerator, pressurePlateBlock, textureSource);
    }

    public final void registerPost(class_4910 modelGenerator, class_2248 block, class_2248 textureSource) {
        class_4944 textureMap = class_4944.method_25897((class_2248)textureSource);
        class_2960 identifier = BlockusModels.TEMPLATE_POST.method_25846(block, textureMap, modelGenerator.field_22831);
        class_807 modelVariant = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_POST_CONNECT.method_25846(block, textureMap, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_POST_CONNECT_TOP.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(BlockusModelProvider.createPostBlockState(block, class_4910.method_67835((class_2960)identifier), modelVariant, modelVariant2, class_4910.method_67835((class_2960)Blockus.id("block/chain_connect")), class_4910.method_67835((class_2960)Blockus.id("block/chain_connect_top"))));
        modelGenerator.method_25623(block, identifier);
    }

    public static class_4917 createPostBlockState(class_2248 postBlock, class_807 postModelId, class_807 sideModelId, class_807 topModelId, class_807 chainModelId, class_807 topChainModelId) {
        return class_4922.method_25758((class_2248)postBlock).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048), postModelId.method_67929(class_4910.field_56782).method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052), postModelId).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11051), postModelId.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847(PostBlock.NORTH, (Comparable)((Object)PostBlock.ConnectionType.POST)), topModelId.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847(PostBlock.SOUTH, (Comparable)((Object)PostBlock.ConnectionType.POST)), sideModelId.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847(PostBlock.EAST, (Comparable)((Object)PostBlock.ConnectionType.POST)), topModelId.method_67929(class_4910.field_56782).method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847(PostBlock.WEST, (Comparable)((Object)PostBlock.ConnectionType.POST)), sideModelId.method_67929(class_4910.field_56782).method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847(PostBlock.UP, (Comparable)((Object)PostBlock.ConnectionType.POST)), topModelId).method_25762(class_4910.method_67834().method_67847(PostBlock.DOWN, (Comparable)((Object)PostBlock.ConnectionType.POST)), sideModelId).method_25762(class_4910.method_67834().method_67847(PostBlock.NORTH, (Comparable)((Object)PostBlock.ConnectionType.CHAIN)), topChainModelId.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847(PostBlock.SOUTH, (Comparable)((Object)PostBlock.ConnectionType.CHAIN)), chainModelId.method_67929(class_4910.field_56782)).method_25762(class_4910.method_67834().method_67847(PostBlock.EAST, (Comparable)((Object)PostBlock.ConnectionType.CHAIN)), topChainModelId.method_67929(class_4910.field_56782).method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847(PostBlock.WEST, (Comparable)((Object)PostBlock.ConnectionType.CHAIN)), chainModelId.method_67929(class_4910.field_56782).method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847(PostBlock.UP, (Comparable)((Object)PostBlock.ConnectionType.CHAIN)), topChainModelId).method_25762(class_4910.method_67834().method_67847(PostBlock.DOWN, (Comparable)((Object)PostBlock.ConnectionType.CHAIN)), chainModelId);
    }

    public final void registerCookieBlock(class_4910 modelGenerator) {
        class_2248 block = BlockusBlocks.COOKIE_BLOCK;
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4946.field_23036.method_25923(block, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859((class_4926)class_4926.method_67864((class_2769)Properties.BITES_9).method_25794((Comparable)Integer.valueOf(0), (Object)class_4910.method_67835((class_2960)class_4941.method_25842((class_2248)block))).method_25794((Comparable)Integer.valueOf(1), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice1"))).method_25794((Comparable)Integer.valueOf(2), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice2"))).method_25794((Comparable)Integer.valueOf(3), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice3"))).method_25794((Comparable)Integer.valueOf(4), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice4"))).method_25794((Comparable)Integer.valueOf(5), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice5"))).method_25794((Comparable)Integer.valueOf(6), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice6"))).method_25794((Comparable)Integer.valueOf(7), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice7"))).method_25794((Comparable)Integer.valueOf(8), (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_slice8")))));
    }

    public final void registerAmethystLamp(class_4910 modelGenerator) {
        class_2248 block = BlockusBlocks.AMETHYST_LAMP;
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4946.field_23036.method_25923(block, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)modelGenerator.method_25557(block, "_low", class_4943.field_22972, class_4944::method_25875));
        class_807 modelVariant3 = class_4910.method_67835((class_2960)modelGenerator.method_25557(block, "_medium", class_4943.field_22972, class_4944::method_25875));
        class_807 modelVariant4 = class_4910.method_67835((class_2960)modelGenerator.method_25557(block, "_high", class_4943.field_22972, class_4944::method_25875));
        modelGenerator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859((class_4926)class_4926.method_67864((class_2769)class_2741.field_12511).method_25794((Comparable)Integer.valueOf(0), (Object)class_4910.method_67835((class_2960)class_4941.method_25842((class_2248)block))).method_25794((Comparable)Integer.valueOf(1), (Object)modelVariant2).method_25794((Comparable)Integer.valueOf(2), (Object)modelVariant2).method_25794((Comparable)Integer.valueOf(3), (Object)modelVariant2).method_25794((Comparable)Integer.valueOf(4), (Object)modelVariant2).method_25794((Comparable)Integer.valueOf(5), (Object)modelVariant2).method_25794((Comparable)Integer.valueOf(6), (Object)modelVariant3).method_25794((Comparable)Integer.valueOf(7), (Object)modelVariant3).method_25794((Comparable)Integer.valueOf(8), (Object)modelVariant3).method_25794((Comparable)Integer.valueOf(9), (Object)modelVariant3).method_25794((Comparable)Integer.valueOf(10), (Object)modelVariant3).method_25794((Comparable)Integer.valueOf(11), (Object)modelVariant4).method_25794((Comparable)Integer.valueOf(12), (Object)modelVariant4).method_25794((Comparable)Integer.valueOf(13), (Object)modelVariant4).method_25794((Comparable)Integer.valueOf(14), (Object)modelVariant4).method_25794((Comparable)Integer.valueOf(15), (Object)modelVariant4)));
    }

    public final void registerSmallHedge(class_4910 modelGenerator, class_2248 hedgeBlock, class_2248 textureSource) {
        this.registerSmallHedge(modelGenerator, hedgeBlock, textureSource, false, 0);
    }

    public final void registerSmallHedge(class_4910 modelGenerator, class_2248 hedgeBlock, class_2248 textureSource, int tintColor) {
        this.registerSmallHedge(modelGenerator, hedgeBlock, textureSource, true, tintColor);
    }

    public final void registerSmallHedge(class_4910 modelGenerator, class_2248 hedgeBlock, class_2248 textureSource, boolean isTinted, int tintColor) {
        class_4944 textureMap = class_4944.method_25883((class_4945)BlockusTextureKey.HEDGE, (class_2960)class_4944.method_25860((class_2248)textureSource));
        class_807 weightedVariant = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_HEDGE_POST.method_25846(hedgeBlock, textureMap, modelGenerator.field_22831));
        class_807 weightedVariant2 = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_HEDGE_SIDE.method_25846(hedgeBlock, textureMap, modelGenerator.field_22831));
        class_807 weightedVariant3 = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_HEDGE_SIDE_ALT.method_25846(hedgeBlock, textureMap, modelGenerator.field_22831));
        class_807 weightedVariant4 = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_HEDGE_NOSIDE.method_25846(hedgeBlock, textureMap, modelGenerator.field_22831));
        class_807 weightedVariant5 = class_4910.method_67835((class_2960)BlockusModels.TEMPLATE_HEDGE_NOSIDE_ALT.method_25846(hedgeBlock, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4922.method_25758((class_2248)hedgeBlock).method_25764(weightedVariant).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), weightedVariant2.method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), weightedVariant2.method_67929(class_4910.field_56785).method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), weightedVariant3.method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), weightedVariant3.method_67929(class_4910.field_56785).method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), weightedVariant4.method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), weightedVariant5.method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), weightedVariant5.method_67929(class_4910.field_56785).method_67929(class_4910.field_56781)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), weightedVariant4.method_67929(class_4910.field_56787).method_67929(class_4910.field_56781)));
        class_2960 identifier = BlockusModels.TEMPLATE_HEDGE_INVENTORY.method_25846(hedgeBlock, textureMap, modelGenerator.field_22831);
        if (isTinted) {
            modelGenerator.method_65402(hedgeBlock, identifier, class_10410.method_65480((int)tintColor));
        } else {
            modelGenerator.method_25623(hedgeBlock, identifier);
        }
    }

    public final void registerCarpet(class_4910 modelGenerator, class_2248 wool, class_2248 carpet) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4946.field_23044.get(wool).method_25916(carpet, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25644((class_2248)carpet, (class_807)modelVariant));
    }

    public final void registerDirectionalCarpet(class_4910 modelGenerator, class_2248 block, class_2248 carpet) {
        class_4946.field_23044.get(block).method_25916(carpet, modelGenerator.field_22831);
        modelGenerator.field_22830.accept(class_4925.method_67853((class_2248)carpet, (class_807)class_4910.method_67835((class_2960)class_4941.method_25842((class_2248)carpet))).method_25775(BlockusModelProvider.createUpDefaultRotationStates()));
    }

    public final void registerBlockStairsSlabWithBottom(class_4910 modelGenerator, class_2248 block, class_2248 stairs, class_2248 slab, class_2248 base) {
        class_2960 textureID = class_4944.method_25866((class_2248)base, (String)"_bottom");
        class_4944 blockTextureMap = class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)textureID);
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(textureID);
        this.createBlock(modelGenerator, block, blockTextureMap);
        this.createStairs(modelGenerator, stairs, textureMap);
        this.createSlab(modelGenerator, slab, textureMap, BlockusModelProvider.getBlockId(block));
    }

    public final void registerBlockStairsSlabWithTop(class_4910 modelGenerator, class_2248 block, class_2248 stairs, class_2248 slab, class_2248 base) {
        class_2960 textureID = class_4944.method_25866((class_2248)base, (String)"_top");
        class_4944 blockTextureMap = class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)textureID);
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(textureID);
        this.createBlock(modelGenerator, block, blockTextureMap);
        this.createStairs(modelGenerator, stairs, textureMap);
        this.createSlab(modelGenerator, slab, textureMap, BlockusModelProvider.getBlockId(block));
    }

    public final void registerBlockStairsSlabwithTopBottom(class_4910 modelGenerator, class_2248 block, class_2248 stairs, class_2248 slab) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)block), class_4944.method_25866((class_2248)block, (String)"_top"), class_4944.method_25866((class_2248)block, (String)"_bottom"));
        this.createBlock(modelGenerator, block, class_4943.field_22977, textureMap);
        this.createStairs(modelGenerator, stairs, textureMap);
        this.createSlab(modelGenerator, slab, textureMap, BlockusModelProvider.getBlockId(block));
    }

    public final void registerStairs(class_4910 modelGenerator, class_2248 block, class_2248 textureSource) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)textureSource));
        this.createStairs(modelGenerator, block, textureMap);
    }

    public final void registerSlab(class_4910 modelGenerator, class_2248 block, class_2248 textureSource) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)textureSource));
        this.createSlab(modelGenerator, block, textureMap, class_4944.method_25860((class_2248)textureSource));
    }

    public final void registerStairsAndSlab(class_4910 modelGenerator, class_2248 stairs, class_2248 slab, class_2248 block) {
        this.registerStairs(modelGenerator, stairs, block);
        this.registerSlab(modelGenerator, slab, block);
    }

    public final void registerSlabwithTop(class_4910 modelGenerator, class_2248 block, class_2248 textureSource, class_2248 end) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)textureSource), class_4944.method_25866((class_2248)end, (String)"_top"));
        this.createSlab(modelGenerator, block, textureMap, class_4944.method_25860((class_2248)textureSource));
    }

    public final void registerWall(class_4910 modelGenerator, class_2248 block, class_2248 textureSource) {
        class_4944 textureMap = class_4944.method_25883((class_4945)class_4945.field_23027, (class_2960)class_4944.method_25860((class_2248)textureSource));
        this.createWall(modelGenerator, block, textureMap);
    }

    public final void registerButton(class_4910 modelGenerator, class_2248 buttonBlock, class_2960 textureSource) {
        class_4944 textureMap = class_4944.method_25869((class_2960)textureSource);
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22981.method_25846(buttonBlock, textureMap, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)class_4943.field_22982.method_25846(buttonBlock, textureMap, modelGenerator.field_22831));
        class_2960 identifier = class_4943.field_22983.method_25846(buttonBlock, textureMap, modelGenerator.field_22831);
        modelGenerator.field_22830.accept(class_4910.method_25654((class_2248)buttonBlock, (class_807)modelVariant, (class_807)modelVariant2));
        modelGenerator.method_25623(buttonBlock, identifier);
    }

    public final void registerPressurePlate(class_4910 modelGenerator, class_2248 pressurePlateBlock, class_2960 textureSource) {
        class_4944 textureMap = class_4944.method_25869((class_2960)textureSource);
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22906.method_25846(pressurePlateBlock, textureMap, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)class_4943.field_22907.method_25846(pressurePlateBlock, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25673((class_2248)pressurePlateBlock, (class_807)modelVariant, (class_807)modelVariant2));
    }

    public final void registerRedstoneLamp(class_4910 modelGenerator, class_2248 block, class_2248 lit) {
        this.registerLitRedstoneLamp(modelGenerator, block, lit);
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4946.field_23036.method_25923(block, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)modelGenerator.method_25557(block, "_on", class_4943.field_22972, class_4944::method_25875));
        modelGenerator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859(class_4910.method_25565((class_2746)class_2741.field_12548, (class_807)modelVariant2, (class_807)modelVariant)));
    }

    public final void registerLitRedstoneLamp(class_4910 modelGenerator, class_2248 block, class_2248 lit) {
        class_4944 textureMap = class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)class_4944.method_25866((class_2248)block, (String)"_on"));
        this.createBlock(modelGenerator, lit, textureMap);
    }

    public void createAxisRotatedCubeColumn(class_4910 modelGenerator, class_2248 block, class_4944 textureMap) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22974.method_25846(block, textureMap, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)class_4943.field_22975.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25667((class_2248)block, (class_807)modelVariant, (class_807)modelVariant2));
    }

    public final void registerAxisRotatedCubeColumn(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25897((class_2248)block);
        this.createAxisRotatedCubeColumn(modelGenerator, block, textureMap);
    }

    public final void registerAxisRotatedCubeColumn(class_4910 modelGenerator, class_2248 block, class_2248 end) {
        class_4944 textureMap = class_4944.method_25870((class_2960)class_4944.method_25860((class_2248)block), (class_2960)class_4944.method_25860((class_2248)end));
        this.createAxisRotatedCubeColumn(modelGenerator, block, textureMap);
    }

    public final void registerCubeColumn(class_4910 modelGenerator, class_2248 block, class_2248 end) {
        class_4944 textureMap = class_4944.method_25870((class_2960)class_4944.method_25860((class_2248)block), (class_2960)class_4944.method_25866((class_2248)end, (String)"_top"));
        this.createBlock(modelGenerator, block, class_4943.field_22974, textureMap);
    }

    public final void registerCubeColumnNoSuffix(class_4910 modelGenerator, class_2248 block, class_2248 end) {
        class_4944 textureMap = class_4944.method_25870((class_2960)class_4944.method_25860((class_2248)block), (class_2960)class_4944.method_25860((class_2248)end));
        this.createBlock(modelGenerator, block, class_4943.field_22974, textureMap);
    }

    public final void registerCubeBottomTop(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)block), class_4944.method_25866((class_2248)block, (String)"_top"), class_4944.method_25866((class_2248)block, (String)"_bottom"));
        this.createBlock(modelGenerator, block, class_4943.field_22977, textureMap);
    }

    public final void registerCubeBottomTop(class_4910 modelGenerator, class_2248 block, class_2248 bottom) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)block), class_4944.method_25866((class_2248)block, (String)"_top"), class_4944.method_25860((class_2248)bottom));
        this.createBlock(modelGenerator, block, class_4943.field_22977, textureMap);
    }

    public final void registerUpDefaultFacingBlock(class_4910 modelGenerator, class_2248 block) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4946.field_23036.method_25923(block, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4925.method_67853((class_2248)block, (class_807)modelVariant).method_25775(BlockusModelProvider.createUpDefaultRotationStates()));
    }

    public final void registerTopBottomFacingBottom(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25860((class_2248)block), class_4944.method_25866((class_2248)block, (String)"_top"), class_4944.method_25866((class_2248)block, (String)"_bottom"));
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22977.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4925.method_67853((class_2248)block, (class_807)modelVariant).method_25775(BlockusModelProvider.createUpDefaultRotationStates()));
    }

    public final void registerPumpkins(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25894((class_2248)class_2246.field_46282);
        modelGenerator.method_25550(block, textureMap);
    }

    public final void registerSturdyStone(class_4910 modelGenerator) {
        class_2960 identifier = class_4944.method_25866((class_2248)class_2246.field_10181, (String)"_top");
        this.createBlock(modelGenerator, BlockusBlocks.STURDY_STONE, class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)identifier));
    }

    public final void registerSmoothStoneStairs(class_4910 modelGenerator) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(class_4944.method_25866((class_2248)class_2246.field_10136, (String)"_side"), class_4944.method_25860((class_2248)class_2246.field_10360));
        this.createStairs(modelGenerator, BlockusBlocks.SMOOTH_STONE_STAIRS, textureMap);
    }

    public final void registerNeonBlock(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)class_4944.method_25860((class_2248)block));
        this.createBlock(modelGenerator, block, BlockusModels.NEON_BLOCK_TEMPLATE, textureMap);
    }

    public final void registerFishCrate(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = BlockusModelProvider.sideTopBottom(BlockusModelProvider.getBlockId("fish_crate_side"), class_4944.method_25860((class_2248)block), BlockusModelProvider.getBlockId("fish_crate_bottom"));
        this.createBlock(modelGenerator, block, class_4943.field_22977, textureMap);
    }

    public final void registerCopperBlocks(class_4910 modelGenerator, CopperBundle block, BlockusFamilies.CopperFamily family) {
        modelGenerator.method_25650(block.block()).method_33522(family.unwaxed).method_54827(block.block(), block.blockWaxed()).method_33522(family.waxed);
    }

    public final void registerCrate(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = BlockusModelProvider.sideTop(class_4944.method_25866((class_2248)block, (String)"_side"), class_4944.method_25860((class_2248)block));
        this.createBlock(modelGenerator, block, BlockusModels.CRATE_TEMPLATE, textureMap);
    }

    public final void registerBreadBox(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = BlockusModelProvider.frontTopSideBottom(block);
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22979.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4925.method_67853((class_2248)block, (class_807)modelVariant).method_25775((class_4926)class_4926.method_67869((class_2769)class_2741.field_12481).method_25794((Comparable)class_2350.field_11034, (Object)class_4910.field_56785).method_25794((Comparable)class_2350.field_11035, (Object)class_4910.field_56786).method_25794((Comparable)class_2350.field_11039, (Object)class_4910.field_56787).method_25794((Comparable)class_2350.field_11043, (Object)class_4910.field_56780)));
    }

    public void registerLegacyStonecutter(class_4910 modelGenerator, class_2248 block) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23012, class_4944.method_25866((class_2248)block, (String)"_front")).method_25868(class_4945.field_23024, class_4944.method_25866((class_2248)block, (String)"_bottom")).method_25868(class_4945.field_23023, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23019, class_4944.method_25866((class_2248)block, (String)"_front")).method_25868(class_4945.field_23020, class_4944.method_25866((class_2248)block, (String)"_front")).method_25868(class_4945.field_23021, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23022, class_4944.method_25866((class_2248)block, (String)"_side"));
        this.createBlock(modelGenerator, block, class_4943.field_22942, textureMap);
    }

    private void registerDiagonalTimberFrame(class_4910 modelGenerator, class_2248 block) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4941.method_25842((class_2248)block));
        class_2960 identifier = class_4944.method_25866((class_2248)block, (String)"_right");
        class_2960 identifier2 = class_4944.method_25866((class_2248)block, (String)"_left");
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23012, identifier).method_25868(class_4945.field_23019, identifier).method_25868(class_4945.field_23020, identifier).method_25868(class_4945.field_23021, identifier).method_25868(class_4945.field_23022, identifier2).method_25868(class_4945.field_23024, identifier2).method_25868(class_4945.field_23023, identifier2);
        class_4943.field_22942.method_25846(block, textureMap, modelGenerator.field_22831);
        modelGenerator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859((class_4926)class_4926.method_67864((class_2769)class_2741.field_12481).method_25794((Comparable)class_2350.field_11043, (Object)modelVariant).method_25794((Comparable)class_2350.field_11035, (Object)modelVariant.method_67929(class_4910.field_56786)).method_25794((Comparable)class_2350.field_11039, (Object)modelVariant.method_67929(class_4910.field_56787)).method_25794((Comparable)class_2350.field_11034, (Object)modelVariant.method_67929(class_4910.field_56785))));
    }

    public final void registerBeveledGlassPane(class_4910 modelGenerator, class_2248 glass, class_2248 glassPane) {
        modelGenerator.method_25641(glass);
        class_4944 textureMap = class_4944.method_25873((class_2248)glass, (class_2248)BlockusBlocks.BEVELED_GLASS_PANE);
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22953.method_25846(glassPane, textureMap, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)class_4943.field_22954.method_25846(glassPane, textureMap, modelGenerator.field_22831));
        class_807 modelVariant3 = class_4910.method_67835((class_2960)class_4943.field_22955.method_25846(glassPane, textureMap, modelGenerator.field_22831));
        class_807 modelVariant4 = class_4910.method_67835((class_2960)class_4943.field_22951.method_25846(glassPane, textureMap, modelGenerator.field_22831));
        class_807 modelVariant5 = class_4910.method_67835((class_2960)class_4943.field_22952.method_25846(glassPane, textureMap, modelGenerator.field_22831));
        class_1792 item = glassPane.method_8389();
        modelGenerator.method_65399(item, modelGenerator.method_65400(item, glass));
        modelGenerator.field_22830.accept(class_4922.method_25758((class_2248)glassPane).method_25764(modelVariant).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), modelVariant2).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), modelVariant2.method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), modelVariant3).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), modelVariant3.method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), modelVariant4).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), modelVariant5).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), modelVariant5.method_67929(class_4910.field_56785)).method_25762(class_4910.method_67834().method_67847((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), modelVariant4.method_67929(class_4910.field_56787)));
    }

    public static void registerColoredTiles(class_4910 modelGenerator, class_2248 block, class_2248 tile1, class_2248 tile2) {
        class_4944 textures = BlockusModelProvider.tilesTextures(tile1, tile2);
        BlockusModels.CUBE_TILES.method_25846(block, textures, modelGenerator.field_22831);
        BlockusModels.CUBE_TILES_2.method_25846(block, textures, modelGenerator.field_22831);
        modelGenerator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859((class_4926)class_4926.method_67864((class_2769)class_2741.field_12529).method_25794((Comparable)class_2350.class_2351.field_11048, (Object)class_4910.method_67835((class_2960)class_4941.method_25842((class_2248)block))).method_25794((Comparable)class_2350.class_2351.field_11051, (Object)class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)block, (String)"_2")))));
    }

    public final void registerColoredTilesSimple(class_4910 modelGenerator, class_2248 block) {
        class_2960 identifier = BlockusModelProvider.getModifiedBlockId(block, "_colored", "");
        this.createBlock(modelGenerator, block, class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)identifier));
    }

    public final void createBlock(class_4910 modelGenerator, class_2248 block, class_4942 model, class_4944 textureMap) {
        modelGenerator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_807)class_4910.method_67835((class_2960)model.method_25846(block, textureMap, modelGenerator.field_22831))));
    }

    public final void createBlock(class_4910 modelGenerator, class_2248 block, class_4944 textureMap) {
        modelGenerator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_807)class_4910.method_67835((class_2960)class_4943.field_22972.method_25846(block, textureMap, modelGenerator.field_22831))));
    }

    public final void createStairs(class_4910 modelGenerator, class_2248 block, class_4944 textureMap) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22913.method_25846(block, textureMap, modelGenerator.field_22831));
        class_2960 identifier = class_4943.field_22912.method_25846(block, textureMap, modelGenerator.field_22831);
        class_807 modelVariant2 = class_4910.method_67835((class_2960)class_4943.field_22914.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25646((class_2248)block, (class_807)modelVariant, (class_807)class_4910.method_67835((class_2960)identifier), (class_807)modelVariant2));
        modelGenerator.method_25623(block, identifier);
    }

    public final void createSlab(class_4910 modelGenerator, class_2248 block, class_4944 textureMap, class_2960 doubleSlab) {
        class_2960 identifier = class_4943.field_22909.method_25846(block, textureMap, modelGenerator.field_22831);
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22910.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25668((class_2248)block, (class_807)class_4910.method_67835((class_2960)identifier), (class_807)modelVariant, (class_807)class_4910.method_67835((class_2960)doubleSlab)));
        modelGenerator.method_25623(block, identifier);
    }

    public final void createWall(class_4910 modelGenerator, class_2248 block, class_4944 textureMap) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22991.method_25846(block, textureMap, modelGenerator.field_22831));
        class_807 modelVariant2 = class_4910.method_67835((class_2960)class_4943.field_22992.method_25846(block, textureMap, modelGenerator.field_22831));
        class_807 modelVariant3 = class_4910.method_67835((class_2960)class_4943.field_22993.method_25846(block, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25636((class_2248)block, (class_807)modelVariant, (class_807)modelVariant2, (class_807)modelVariant3));
        class_2960 identifier = class_4943.field_22994.method_25846(block, textureMap, modelGenerator.field_22831);
        modelGenerator.method_25623(block, identifier);
    }

    public static class_4926 createUpDefaultRotationStates() {
        return class_4926.method_67869((class_2769)class_2741.field_12525).method_25794((Comparable)class_2350.field_11033, (Object)class_4910.field_56783).method_25794((Comparable)class_2350.field_11036, (Object)class_4910.field_56780).method_25794((Comparable)class_2350.field_11043, (Object)class_4910.field_56784.then(class_4910.field_56786)).method_25794((Comparable)class_2350.field_11035, (Object)class_4910.field_56784).method_25794((Comparable)class_2350.field_11039, (Object)class_4910.field_56784.then(class_4910.field_56785)).method_25794((Comparable)class_2350.field_11034, (Object)class_4910.field_56784.then(class_4910.field_56787));
    }

    public static class_2960 getTilesId(class_2248 block) {
        return BlockusModelProvider.getModifiedBlockId(block, "_concrete", "_tiles");
    }

    public static class_2960 getBlockId(String id) {
        return Blockus.id("block/" + id);
    }

    public static class_2960 getBlockId(class_2248 block) {
        return Blockus.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832());
    }

    public static class_2960 getModifiedBlockId(class_2248 block, String target, String replacement) {
        return Blockus.id("block/" + class_7923.field_41175.method_10221((Object)block).method_12832().replace(target, replacement));
    }

    private static class_4944 tilesTextures(class_2248 tile1, class_2248 tile2) {
        return new class_4944().method_25868(BlockusTextureKey.TILE_1, BlockusModelProvider.getTilesId(tile1)).method_25868(BlockusTextureKey.TILE_2, BlockusModelProvider.getTilesId(tile2));
    }

    public static class_4944 sideTop(class_2960 block, class_2960 top) {
        return new class_4944().method_25868(class_4945.field_23018, block).method_25868(class_4945.field_23015, top);
    }

    public static class_4944 sideTopBottom(class_2960 block, class_2960 top, class_2960 bottom) {
        return new class_4944().method_25868(class_4945.field_23018, block).method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom);
    }

    public static class_4944 sideTopBottom(class_2960 block, class_2960 end) {
        return new class_4944().method_25868(class_4945.field_23018, block).method_25868(class_4945.field_23015, end).method_25868(class_4945.field_23014, end);
    }

    public static class_4944 sideTopBottom(class_2960 block) {
        return new class_4944().method_25868(class_4945.field_23018, block).method_25868(class_4945.field_23015, block).method_25868(class_4945.field_23014, block);
    }

    public static class_4944 frontTopSideBottom(class_2248 block) {
        return new class_4944().method_25868(class_4945.field_23016, class_4944.method_25860((class_2248)block)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_side"));
    }

    public final void registerTintableCrossBlockState(class_4910 modelGenerator, class_2248 block, class_4910.class_4913 tintType) {
        class_4944 textureMap = tintType.method_65296(block);
        this.registerTintableCrossBlockState(modelGenerator, block, textureMap);
    }

    public final void registerTintableCrossBlockState(class_4910 modelGenerator, class_2248 block, class_4944 crossTexture) {
        class_807 modelVariant = class_4910.method_67835((class_2960)class_4943.field_22921.method_25846(block, crossTexture, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_807)modelVariant));
    }

    public final void registerFlowerPotPlantAndItem(class_4910 modelGenerator, class_2248 block, class_2248 flowerPotBlock, class_4910.class_4913 crossType) {
        modelGenerator.method_65399(block.method_8389(), crossType.method_65297(modelGenerator, block));
        this.registerFlowerPotPlant(modelGenerator, block, flowerPotBlock, crossType);
    }

    public final void registerFlowerPotPlant(class_4910 modelGenerator, class_2248 plantBlock, class_2248 flowerPotBlock, class_4910.class_4913 tintType) {
        this.registerTintableCrossBlockState(modelGenerator, plantBlock, tintType);
        class_4944 textureMap = tintType.method_65298(plantBlock);
        class_807 modelVariant = class_4910.method_67835((class_2960)tintType.method_25727().method_25846(flowerPotBlock, textureMap, modelGenerator.field_22831));
        modelGenerator.field_22830.accept(class_4910.method_25644((class_2248)flowerPotBlock, (class_807)modelVariant));
    }
}

