/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.utils.BlockChecker;
import com.brand.blockus.utils.helper.BlockBuilder;
import com.brand.blockus.utils.helper.BlockFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2436;
import net.minecraft.class_2498;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_5541;

public record BSSWBundle(String type, class_2248 base, class_2248 block, class_2248 stairs, class_2248 slab, class_2248 wall) {
    public static final List<BSSWBundle> LIST = new ArrayList<BSSWBundle>();

    public static List<BSSWBundle> values() {
        return LIST;
    }

    public static Builder of(String type, BlockBuilder blockBuilder) {
        return new Builder(type, blockBuilder);
    }

    public static Builder of(String type, class_2248 base) {
        return new Builder(type, new BlockBuilder(base));
    }

    public static Builder of(String type, class_2248 base, class_3620 mapcolor) {
        return new Builder(type, new BlockBuilder(base).settings(settings -> settings.method_31710(mapcolor)));
    }

    public static Builder of(String type, class_2248 base, int luminance) {
        return new Builder(type, new BlockBuilder(base).settings(settings -> settings.method_9631(state -> luminance)));
    }

    public static Builder of(String type, class_2248 base, class_3619 pistonBehavior) {
        return new Builder(type, new BlockBuilder(base).settings(settings -> settings.method_50012(pistonBehavior)));
    }

    public static Builder of(String type, class_2248 base, class_2498 sound) {
        return new Builder(type, new BlockBuilder(base).settings(settings -> settings.method_9626(sound)));
    }

    public static Builder of(String type, class_2248 base, float hardness, float resistance, class_3620 mapcolor) {
        return new Builder(type, new BlockBuilder(base).settings(settings -> settings.method_9629(hardness, resistance).method_31710(mapcolor)));
    }

    public static Builder of(String type, float hardness, float resistance, class_3620 color) {
        return new Builder(type, new BlockBuilder(BlockFactory.create()).settings(settings -> settings.method_9629(hardness, resistance).method_31710(color)));
    }

    public class_2248[] all() {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        list.add(this.block);
        list.add(this.stairs);
        list.add(this.slab);
        if (this.wall != null) {
            list.add(this.wall);
        }
        return list.toArray(new class_2248[0]);
    }

    public List<class_2248> noWall() {
        return List.of(this.block, this.stairs, this.slab);
    }

    public static class Builder {
        public final String type;
        public final BlockBuilder blockBuilder;
        public boolean includeWall = true;

        public Builder(String type, BlockBuilder blockBuilder) {
            this.type = type;
            this.blockBuilder = blockBuilder;
        }

        public Builder includeWall(boolean include) {
            this.includeWall = include;
            return this;
        }

        public BSSWBundle register() {
            if (BlockChecker.isAmethyst(this.type)) {
                this.blockBuilder.factory(class_5541::new);
            } else if (BlockChecker.isRedstone(this.type)) {
                this.blockBuilder.factory(class_2436::new);
            } else {
                this.blockBuilder.factory(class_2248::new);
            }
            class_2248 base = this.blockBuilder.getBase();
            class_2248 block = this.blockBuilder.register(this.type);
            BSSWBundle bundle = new BSSWBundle(this.type, base, block, BlockFactory.stairs(block), BlockFactory.slab(block), this.includeWall ? BlockFactory.wall(block) : null);
            LIST.add(bundle);
            return bundle;
        }
    }
}

