/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.utils.helper.BlockFactory;
import com.brand.blockus.utils.helper.BlockMaps;
import com.brand.blockus.utils.helper.BlockOrder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_2248;

public record ConcreteBundle(Map<class_1767, ConcreteVariants> colorMap) {
    public static final List<ConcreteBundle> LIST = new ArrayList<ConcreteBundle>();

    public static List<ConcreteBundle> values() {
        return LIST;
    }

    public static Builder of(String id) {
        return new Builder(id);
    }

    public List<class_2248> all() {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        for (class_1767 color : BlockOrder.COLOR) {
            ConcreteVariants variants = this.colorMap.get(color);
            list.add(variants.block());
            list.add(variants.stairs());
            list.add(variants.slab());
            list.add(variants.wall());
            list.add(variants.chiseled());
            list.add(variants.pillar());
        }
        return list;
    }

    public static class Builder {
        public final String id;
        public class_1767 color;

        public Builder(String id) {
            this.id = id;
        }

        public ConcreteBundle register() {
            EnumMap<class_1767, ConcreteVariants> colorMap = new EnumMap<class_1767, ConcreteVariants>(class_1767.class);
            for (class_1767 color : BlockOrder.COLOR) {
                String type = color.method_7792() + "_" + this.id;
                String removeBricks = type.replace("_bricks", "");
                class_2248 base = BlockMaps.CONCRETE_MAP.get(color);
                class_2248 block = BlockFactory.registerCopy(type, base);
                class_2248 stairs = BlockFactory.stairs(block);
                class_2248 slab = BlockFactory.slab(block);
                class_2248 wall = BlockFactory.wall(block);
                class_2248 chiseled = BlockFactory.registerCopy("chiseled_" + removeBricks, base);
                class_2248 pillar = BlockFactory.pillar2(removeBricks + "_pillar", base);
                colorMap.put(color, new ConcreteVariants(block, stairs, slab, wall, chiseled, pillar));
            }
            ConcreteBundle bundle = new ConcreteBundle(colorMap);
            LIST.add(bundle);
            return bundle;
        }
    }

    public record ConcreteVariants(class_2248 block, class_2248 stairs, class_2248 slab, class_2248 wall, class_2248 chiseled, class_2248 pillar) {
    }
}

