/*
 * Decompiled with CFR 0.152.
 */
package com.brand.blockus.registry.content.bundles;

import com.brand.blockus.blocks.base.OrientableBlockBase;
import com.brand.blockus.utils.helper.BlockFactory;
import com.brand.blockus.utils.helper.WoodMaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2389;
import net.minecraft.class_4970;
import net.minecraft.class_9009;

public record TimberFrameBundle(Map<WoodMaps, TimberFrameVariants> woodMap) {
    public static final List<TimberFrameBundle> LIST = new ArrayList<TimberFrameBundle>();

    public static List<TimberFrameBundle> values() {
        return LIST;
    }

    public static class_4970.class_2251 settings(class_2248 base, boolean isBurnable) {
        class_4970.class_2251 blockSettings = BlockFactory.createCopy(base).method_51369();
        return isBurnable ? blockSettings.method_50013() : blockSettings;
    }

    public List<class_2248> all() {
        ArrayList<class_2248> list = new ArrayList<class_2248>();
        for (WoodMaps wood : WoodMaps.values()) {
            TimberFrameVariants variants = this.woodMap.get((Object)wood);
            if (variants == null) continue;
            list.add(variants.block());
            list.add(variants.diagonal());
            list.add(variants.cross());
            list.add(variants.lattice());
            list.add(variants.grate());
        }
        return list;
    }

    public static TimberFrameBundle register() {
        EnumMap<WoodMaps, TimberFrameVariants> woodMap = new EnumMap<WoodMaps, TimberFrameVariants>(WoodMaps.class);
        for (WoodMaps wood : WoodMaps.values()) {
            class_2248 planks = WoodMaps.PLANKS_MAP.get(wood.getId());
            if (planks == null) {
                System.err.println("[WARN] Missing planks for: " + wood.getId());
                continue;
            }
            class_2248 block = BlockFactory.registerOf(wood.getId() + "_timber_frame", TimberFrameBundle.settings(planks, wood.data().isBurnable()));
            class_2248 diagonal = BlockFactory.registerOf(wood.getId() + "_diagonal_timber_frame", OrientableBlockBase::new, TimberFrameBundle.settings(planks, wood.data().isBurnable()));
            class_2248 cross = BlockFactory.registerOf(wood.getId() + "_cross_timber_frame", TimberFrameBundle.settings(planks, wood.data().isBurnable()));
            class_2248 lattice = BlockFactory.registerCopy(wood.getId() + "_lattice", class_2389::new, planks);
            class_2248 grate = BlockFactory.registerCopy(wood.getId() + "_grate", class_9009::new, planks, settings -> settings.method_22488().method_26235(class_2246::method_26114).method_26236(class_2246::method_26122).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
            woodMap.put(wood, new TimberFrameVariants(block, diagonal, cross, lattice, grate));
        }
        TimberFrameBundle bundle = new TimberFrameBundle(woodMap);
        LIST.add(bundle);
        return bundle;
    }

    public record TimberFrameVariants(class_2248 block, class_2248 diagonal, class_2248 cross, class_2248 lattice, class_2248 grate) {
    }
}

