/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class PedestalRecipeCategory
implements IRecipeCategory<PedestalRecipe> {
    public static final RecipeType<PedestalRecipe> TYPE = RecipeType.create((String)"extrabotany", (String)"pedestal_smash", PedestalRecipe.class);
    private final Component localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)ExtraBotanyBlocks.livingrockPedestal);

    public PedestalRecipeCategory(IGuiHelper guiHelper) {
        this.localizedName = Component.m_237115_((String)"extrabotany.jei.pedestal");
        this.background = guiHelper.createBlankDrawable(142, 60);
        this.overlay = guiHelper.createDrawable(ResourceLocation.m_214293_((String)"botania", (String)"textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack.m_41777_());
    }

    public RecipeType<PedestalRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public int getWidth() {
        return 142;
    }

    public int getHeight() {
        return 60;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(PedestalRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        this.background.draw(gui, 0, 0);
        int strikes = recipe.getStrike();
        int exp = recipe.getExp();
        MutableComponent strikesComp = Component.m_237110_((String)"extrabotany.jei.pedestal.tip_strikes", (Object[])new Object[]{strikes});
        MutableComponent expComp = Component.m_237110_((String)"extrabotany.jei.pedestal.tip_exp", (Object[])new Object[]{exp});
        Font font = Minecraft.m_91087_().f_91062_;
        gui.m_280614_(font, (Component)strikesComp, 90, 50, 0x888888, false);
        gui.m_280614_(font, (Component)expComp, 90, 3, 0x888888, false);
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 40, 0);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PedestalRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 12).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 12).addItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        builder.addSlot(RecipeIngredientRole.CATALYST, 62, 12).addItemStack(this.renderStack);
        builder.addSlot(RecipeIngredientRole.CATALYST, 62, 45).addIngredients(recipe.getSmashTools());
    }
}

