/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.integration.jei.crafing;

import io.github.lounode.extrabotany.common.brew.BrewUtil;
import io.github.lounode.extrabotany.common.crafting.recipe.CopyBrewRecipe;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.brew.ManaCocktailItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.BotaniaItems;

public class CopyBrewFormFlaskRecipeWrapper
implements ICraftingCategoryExtension {
    private final ResourceLocation name;

    public CopyBrewFormFlaskRecipeWrapper(CopyBrewRecipe recipe) {
        this.name = recipe.m_6423_();
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper helper, IFocusGroup focusGroup) {
        ItemStack cocktail = focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).filter(f -> ((ItemStack)f.getTypedValue().getIngredient()).m_41720_() == ExtraBotanyItems.manaCocktail).map(f -> (ItemStack)f.getTypedValue().getIngredient()).findFirst().orElse(null);
        ItemStack flask = focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).filter(f -> ((ItemStack)f.getTypedValue().getIngredient()).m_41720_() == BotaniaItems.brewFlask).map(f -> (ItemStack)f.getTypedValue().getIngredient()).findFirst().orElse(null);
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        inputs.add(Collections.singletonList(cocktail != null ? cocktail.m_41777_() : ManaCocktailItem.getDefaultCocktail()));
        ArrayList<ItemStack> flasks = new ArrayList<ItemStack>();
        if (flask != null) {
            flasks.add(flask.m_41777_());
        } else {
            BotaniaAPI.instance().getBrewRegistry().forEach(brew -> {
                ItemStack flaskStack = new ItemStack((ItemLike)BotaniaItems.brewFlask);
                BrewUtil.setBrew(flaskStack, brew);
                flasks.add(flaskStack);
            });
        }
        inputs.add(flasks);
        helper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputs, 0, 0);
        ItemStack output = new ItemStack((ItemLike)ExtraBotanyItems.manaCocktail);
        if (flask != null) {
            BrewUtil.setBrew(output, BrewUtil.getBrew(flask));
        }
        helper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(output));
    }
}

