/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.model;

import io.github.lounode.extrabotany.client.model.ExtrabotanyModelLayers;
import io.github.lounode.extrabotany.common.item.equipment.armor.goblin_slayer.GoblinSlayerArmorItem;
import io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid.PleiadesCombatMaidArmorItem;
import io.github.lounode.extrabotany.common.item.equipment.armor.shadow_warrior.ShadowWarriorArmorItem;
import io.github.lounode.extrabotany.common.item.equipment.armor.starry_idol.StarryIdolArmorItem;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.model.armor.ArmorModel;

public class ArmorModels {
    private static Map<EquipmentSlot, ArmorModel> starryIdol = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> pleiadesCombatMaid = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> shadowWarrior = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> goblinSlayer = Collections.emptyMap();

    private static Map<EquipmentSlot, ArmorModel> make(EntityRendererProvider.Context ctx, ModelLayerLocation inner, ModelLayerLocation outer) {
        EnumMap<EquipmentSlot, ArmorModel> ret = new EnumMap<EquipmentSlot, ArmorModel>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ModelPart mesh = ctx.m_174023_(slot == EquipmentSlot.LEGS ? inner : outer);
            ret.put(slot, new ArmorModel(mesh, slot));
        }
        return ret;
    }

    private static Map<EquipmentSlot, ArmorModel> make(EntityRendererProvider.Context ctx, ModelLayerLocation inner) {
        EnumMap<EquipmentSlot, ArmorModel> ret = new EnumMap<EquipmentSlot, ArmorModel>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ModelPart mesh = ctx.m_174023_(inner);
            ret.put(slot, new ArmorModel(mesh, slot));
        }
        return ret;
    }

    private static Map<EquipmentSlot, ArmorModel> makeIdol(EntityRendererProvider.Context ctx, ModelLayerLocation layer, ModelLayerLocation dressLayer) {
        EnumMap<EquipmentSlot, ArmorModel> ret = new EnumMap<EquipmentSlot, ArmorModel>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ModelPart mesh = ctx.m_174023_(slot != EquipmentSlot.LEGS ? layer : dressLayer);
            ret.put(slot, new ArmorModel(mesh, slot));
        }
        return ret;
    }

    public static void init(EntityRendererProvider.Context ctx) {
        starryIdol = ArmorModels.makeIdol(ctx, ExtrabotanyModelLayers.STARRY_IDOL_ARMOR_NORMAL, ExtrabotanyModelLayers.STARRY_IDOL_ARMOR_DRESS);
        pleiadesCombatMaid = ArmorModels.makeIdol(ctx, ExtrabotanyModelLayers.PLEIADES_COMBAT_MAID_ARMOR_NORMAL, ExtrabotanyModelLayers.PLEIADES_COMBAT_MAID_ARMOR_DRESS);
        shadowWarrior = ArmorModels.makeIdol(ctx, ExtrabotanyModelLayers.SHADOW_WARRIOR_ARMOR_NORMAL, ExtrabotanyModelLayers.SHADOW_WARRIOR_ARMOR_LEGGINGS);
        goblinSlayer = ArmorModels.makeIdol(ctx, ExtrabotanyModelLayers.GOBLIN_SLAYER_ARMOR_NORMAL, ExtrabotanyModelLayers.GOBLIN_SLAYER_ARMOR_LEGGINGS);
    }

    @Nullable
    public static ArmorModel get(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof PleiadesCombatMaidArmorItem) {
            PleiadesCombatMaidArmorItem maid = (PleiadesCombatMaidArmorItem)item;
            return pleiadesCombatMaid.get(maid.m_40402_());
        }
        if (item instanceof ShadowWarriorArmorItem) {
            ShadowWarriorArmorItem warrior = (ShadowWarriorArmorItem)item;
            return shadowWarrior.get(warrior.m_40402_());
        }
        if (item instanceof GoblinSlayerArmorItem) {
            GoblinSlayerArmorItem goblin = (GoblinSlayerArmorItem)item;
            return goblinSlayer.get(goblin.m_40402_());
        }
        if (item instanceof StarryIdolArmorItem) {
            StarryIdolArmorItem idol = (StarryIdolArmorItem)item;
            return starryIdol.get(idol.m_40402_());
        }
        return null;
    }
}

