/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lounode.extrabotany.client.model.ArmorModels;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;

public class GaiaRenderer
extends HumanoidMobRenderer<Gaia, HumanoidModel<Gaia>> {
    public static final float DEFAULT_GRAIN_INTENSITY = 0.05f;
    public static final float DEFAULT_DISFIGURATION = 0.025f;
    private final Model normalModel = (Model)this.m_7200_();
    private final Model slimModel;

    public GaiaRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (HumanoidModel)new Model(ctx.m_174023_(ModelLayers.f_171162_)), 0.0f);
        this.slimModel = new Model(ctx.m_174023_(ModelLayers.f_171166_));
        ArmorModels.init(ctx);
    }

    public void render(@NotNull Gaia dopple, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        Entity view;
        int invulTime = dopple.getInvulTime();
        ShaderInstance shader = CoreShaders.doppleganger();
        if (shader != null) {
            float disfiguration;
            float grainIntensity;
            if (invulTime > 0) {
                grainIntensity = invulTime > 20 ? 1.0f : (float)invulTime * 0.05f;
                disfiguration = grainIntensity * 0.3f;
            } else {
                disfiguration = (0.025f + (float)dopple.f_20916_ * 0.0425f) / 2.0f;
                grainIntensity = 0.05f + (float)dopple.f_20916_ * 0.085f;
            }
            shader.m_173356_("BotaniaGrainIntensity").m_5985_(grainIntensity);
            shader.m_173356_("BotaniaDisfiguration").m_5985_(disfiguration);
        }
        this.f_115290_ = (view = Minecraft.m_91087_().m_91288_()) instanceof AbstractClientPlayer && DefaultPlayerSkin.m_118629_((UUID)view.m_20148_()).equals("slim") ? this.slimModel : this.normalModel;
        super.m_7392_((Mob)dopple, yaw, partialTicks, ms, buffers, light);
        if (shader != null) {
            // empty if block
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Gaia entity) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity2 = mc.m_91288_();
        if (!(entity2 instanceof AbstractClientPlayer)) {
            return DefaultPlayerSkin.m_118627_((UUID)entity.m_20148_());
        }
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)entity2;
        return clientPlayer.m_108560_();
    }

    protected boolean isBodyVisible(Gaia dopple) {
        return true;
    }

    private static class Model
    extends HumanoidModel<Gaia> {
        Model(ModelPart root) {
            super(root, RenderHelper::getDopplegangerLayer);
        }
    }
}

