/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.advancements.MinMaxBoundsExtension;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ManaChargeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("mana_charge");
    public static final ManaChargeTrigger INSTANCE = new ManaChargeTrigger();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, ItemStack itemStack, long mana) {
        this.m_66234_(player, instance -> instance.matches(itemStack, mana));
    }

    public TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext context) {
        ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        MinMaxBoundsExtension.Longs countPredicate = MinMaxBoundsExtension.Longs.fromJson(json.get("mana"));
        return new TriggerInstance(predicate, itemPredicate, countPredicate);
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final MinMaxBoundsExtension.Longs mana;

        public TriggerInstance(ContextAwarePredicate predicate, ItemPredicate item, MinMaxBoundsExtension.Longs count) {
            super(ID, predicate);
            this.item = item;
            this.mana = count;
        }

        public static TriggerInstance manaCharged(ItemPredicate item, MinMaxBoundsExtension.Longs mana) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, item, mana);
        }

        public boolean matches(ItemStack stack, long mana) {
            return this.item.m_45049_(stack) && this.mana.matches(mana);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            json.add("item", this.item.m_45048_());
            json.add("mana", this.mana.m_55328_());
            return json;
        }
    }
}

