/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.block_entity;

import com.google.common.base.Suppliers;
import io.github.lounode.extrabotany.api.block.Pedestal;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtend;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtendBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockTagPredicate;
import io.github.lounode.extrabotany.api.item.NatureEnergyItem;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.common.block.PedestalBlock;
import io.github.lounode.extrabotany.common.block.block_entity.ExtraBotanyBlockEntities;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class PedestalBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements Pedestal {
    public static final BlockPos[] POOL_LOCATIONS = new BlockPos[]{new BlockPos(3, 0, 3), new BlockPos(-3, 0, 3), new BlockPos(3, 0, -3), new BlockPos(-3, 0, -3)};
    public static final String[][] TIER1_PATTERN = new String[][]{{"P___P", "_____", "__0__", "_____", "P___P"}};
    public static final String[][] TIER2_PATTERN = new String[][]{{"P_____P", "_______", "_______", "_______", "_______", "_______", "P_____P"}, {"M_____M", "_P___P_", "_______", "___0___", "_______", "_P___P_", "M_____M"}, {"_______", "_SSSSS_", "_S___S_", "_S___S_", "_S___S_", "_SSSSS_", "_______"}};
    public static final Supplier<IMultiblock> TIER_1_PATCHOULI = Suppliers.memoize(() -> {
        IStateMatcher pedestal = PatchouliAPI.get().tagMatcher(ExtraBotanyTags.Blocks.PEDESTALS);
        return PatchouliAPI.get().makeMultiblock(TIER1_PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.naturaPylon, Character.valueOf('0'), pedestal});
    });
    public static final Supplier<IMultiblock> TIER_2_PATCHOULI = Suppliers.memoize(() -> {
        IStateMatcher pedestal = PatchouliAPI.get().tagMatcher(ExtraBotanyTags.Blocks.PEDESTALS);
        IStateMatcher manaPool = PatchouliAPI.get().tagMatcher(ExtraBotanyTags.Blocks.MANA_POOLS);
        IStateMatcher any = PatchouliAPI.get().anyMatcher();
        return PatchouliAPI.get().makeMultiblock(TIER2_PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.naturaPylon, Character.valueOf('0'), pedestal, Character.valueOf('S'), BotaniaBlocks.shimmerrock, Character.valueOf('M'), manaPool});
    });
    public static final Predicate<BlockInWorld>[][][] TIER_1_PATTERN = BlockPatternExtendBuilder.start().aisle(TIER1_PATTERN[0]).where('_', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.f_61281_)).where('0', BlockInWorld.m_61169_((Predicate)BlockTagPredicate.forTag(ExtraBotanyTags.Blocks.PEDESTALS))).where('P', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BotaniaBlocks.naturaPylon))).createPattern();
    public static final Predicate<BlockInWorld>[][][] TIER_2_PATTERN = BlockPatternExtendBuilder.start().aisle(TIER2_PATTERN[0]).aisle(TIER2_PATTERN[1]).aisle(TIER2_PATTERN[2]).where('_', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.f_61281_)).where('0', BlockInWorld.m_61169_((Predicate)BlockTagPredicate.forTag(ExtraBotanyTags.Blocks.PEDESTALS))).where('P', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BotaniaBlocks.naturaPylon))).where('S', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)BotaniaBlocks.shimmerrock))).where('M', BlockInWorld.m_61169_((Predicate)BlockTagPredicate.forTag(ExtraBotanyTags.Blocks.MANA_POOLS))).createPattern();
    public final int FINISH_CRAFT_STRIKE_FLAG = -1;
    public int tickCount;
    private int strikes;
    private int tier;
    private Map<ItemStack, ItemFrame> automaticHammers = new HashMap<ItemStack, ItemFrame>();

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        this(ExtraBotanyBlockEntities.PEDESTAL, pos, state);
    }

    public PedestalBlockEntity(BlockEntityType<? extends PedestalBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setStrikes(0);
    }

    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Function handler;
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        List<Function> handlers = Arrays.asList(v -> this.handleExtractFinishItem(state, world, pos, player, hand, hit), v -> this.handleSmashNew(state, world, pos, player, hand, hit), v -> this.handleReversePlaceItem(state, world, pos, player, hand, hit), v -> this.handlePlaceItemNew(state, world, pos, player, hand, hit));
        Map.Entry<Object, Boolean> result = new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME, false);
        Iterator<Function> iterator = handlers.iterator();
        while (iterator.hasNext() && (result = (Map.Entry)(handler = iterator.next()).apply(null)).getKey() == InteractionResult.CONSUME) {
        }
        player.m_6674_((Boolean)result.getValue() != false ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        return (InteractionResult)result.getKey();
    }

    public Map.Entry<InteractionResult, Boolean> handleExtractFinishItem(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_7983_() && this.strikes == -1) {
            ItemStack stack = this.extractPedestal();
            if (player.m_36356_(stack)) {
                this.playSound();
            } else {
                Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)stack);
            }
            return new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME_PARTIAL, false);
        }
        return new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME, false);
    }

    public Map.Entry<InteractionResult, Boolean> handleSmashNew(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean swingOffHand = false;
        if (!this.m_7983_()) {
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean denyInteraction = false;
            for (Recipe recipe : ExtraBotanyRecipeTypes.getRecipes(this.f_58857_, ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE).values()) {
                PedestalRecipe recipe2;
                if (!(recipe instanceof PedestalRecipe) || !(recipe2 = (PedestalRecipe)recipe).getSmashTools().test(mainHandItem) && !recipe2.getSmashTools().test(offHandItem)) continue;
                denyInteraction = true;
                if (!recipe2.getInput().test(this.getItem())) continue;
                ItemStack smashTools = null;
                if (recipe2.getSmashTools().test(mainHandItem)) {
                    smashTools = mainHandItem;
                } else if (recipe2.getSmashTools().test(offHandItem)) {
                    smashTools = offHandItem;
                    swingOffHand = true;
                }
                boolean finalSwingOffHand = swingOffHand;
                int expBoost = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)smashTools);
                int efficiency = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)smashTools);
                smashTools.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(finalSwingOffHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND));
                ++this.strikes;
                if (!this.f_58857_.m_5776_()) {
                    PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/goodtek"), (String)"code_triggered");
                }
                if (this.strikes > 0 && this.strikes < recipe2.getStrike()) {
                    this.f_58857_.m_5594_(null, pos, SoundEvents.f_12446_, SoundSource.PLAYERS, 0.8f, ((player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    continue;
                }
                ItemStack output = recipe2.getOutput().m_41777_();
                this.setItem(output);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.PLAYERS, 0.8f, ((player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                if (!this.f_58857_.m_5776_()) {
                    PedestalBlockEntity.createExperience((ServerLevel)this.f_58857_, player.m_20182_(), recipe2.getExp());
                }
                this.strikes = -1;
                break;
            }
            return denyInteraction ? new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME_PARTIAL, swingOffHand) : new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME, swingOffHand);
        }
        return new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME, swingOffHand);
    }

    public Map.Entry<InteractionResult, Boolean> handleReversePlaceItem(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean swingOffHand = false;
        if (this.m_7983_()) {
            boolean reversePriority = false;
            ItemStack mainHandItem = player.m_21205_();
            if (!mainHandItem.m_41619_()) {
                for (Recipe recipe : ExtraBotanyRecipeTypes.getRecipes(this.f_58857_, ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE).values()) {
                    PedestalRecipe recipe2;
                    if (!(recipe instanceof PedestalRecipe) || !(recipe2 = (PedestalRecipe)recipe).getSmashTools().test(mainHandItem)) continue;
                    reversePriority = true;
                    break;
                }
            }
            if (reversePriority) {
                ItemStack offHandItem = player.m_21206_();
                if (!offHandItem.m_41619_()) {
                    this.insertPedestal(offHandItem);
                    this.playSound();
                    swingOffHand = true;
                } else if (!mainHandItem.m_41619_()) {
                    this.insertPedestal(mainHandItem);
                    this.playSound();
                }
                return new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME_PARTIAL, swingOffHand);
            }
        }
        return new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME, swingOffHand);
    }

    public Map.Entry<InteractionResult, Boolean> handlePlaceItemNew(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean swingOffHand = false;
        if (this.m_7983_()) {
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            if (!mainHandItem.m_41619_()) {
                this.insertPedestal(mainHandItem);
                this.playSound();
            } else if (!offHandItem.m_41619_()) {
                this.insertPedestal(offHandItem);
                this.playSound();
                swingOffHand = true;
            }
        } else {
            ItemStack stack = this.extractPedestal();
            if (player.m_36356_(stack)) {
                this.playSound();
            } else {
                Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)stack);
            }
        }
        return new AbstractMap.SimpleEntry<InteractionResult, Boolean>(InteractionResult.CONSUME, swingOffHand);
    }

    private void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }

    private static void createExperience(ServerLevel world, Vec3 pos, int amount) {
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)pos, (int)amount);
    }

    public void insertPedestal(ItemStack itemStack) {
        ItemStack stack = itemStack.m_41620_(1);
        this.setItem(stack);
    }

    public ItemStack extractPedestal() {
        ItemStack stack = this.getItem().m_41777_();
        this.setItem(ItemStack.f_41583_);
        return stack;
    }

    @Override
    public ItemStack getItem() {
        return this.m_8020_(0);
    }

    @Override
    public void setItem(ItemStack itemStack) {
        this.m_6836_(0, itemStack);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.setStrikes(0);
        BlockState state = this.m_58900_();
        this.f_58857_.m_7696_(this.m_58899_(), state.m_60734_(), 0, 0);
        this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)PedestalBlock.HAS_ITEM, (Comparable)Boolean.valueOf(!stack.m_41619_())), 3);
        super.m_6836_(index, stack);
        this.markUpdated();
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public ItemStack m_7407_(int index, int count) {
        this.setStrikes(0);
        BlockState state = this.m_58900_();
        this.f_58857_.m_7696_(this.m_58899_(), state.m_60734_(), 0, 0);
        this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)PedestalBlock.HAS_ITEM, (Comparable)Boolean.valueOf(false)), 3);
        ItemStack superItemStack = super.m_7407_(index, count);
        this.markUpdated();
        return superItemStack;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity self) {
        NatureEnergyItem natureItem;
        if (self.tickCount % 10 == 0) {
            self.markUpdated();
        }
        if (self.tickCount % 100 == 0) {
            self.updateTier();
        }
        if ((natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(self.getItem())) != null) {
            int chargeAmount;
            if (self.tickCount % 20 == 0) {
                self.updateTier();
            }
            if ((chargeAmount = self.getChargeAmount()) > 0) {
                natureItem.addEnergy(chargeAmount);
                WispParticleData data = WispParticleData.wisp((float)0.5f, (float)0.15f, (float)0.8f, (float)0.15f);
                ((ServerLevel)level).m_8767_((ParticleOptions)data, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.1f), (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (self.tickCount % 20 == 0) {
            Player nearestPlayer;
            int lastHammers = self.automaticHammers.size();
            self.updateAutomaticHammers();
            if (lastHammers != self.automaticHammers.size() && self.automaticHammers.size() == 4 && (nearestPlayer = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10.0, false)) != null) {
                PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)nearestPlayer), (ResourceLocation)ResourceLocationHelper.prefix("main/kurukuru"), (String)"code_triggered");
            }
        }
        if (self.tickCount % 10 == 0 && !self.m_7983_()) {
            ItemStack hammer;
            ItemFrame frame;
            Iterator<ItemStack> iterator = self.automaticHammers.keySet().iterator();
            while (!(!iterator.hasNext() || (frame = self.automaticHammers.get(hammer = iterator.next())) != null && frame.m_6084_() && self.tryAutoSmash(hammer))) {
            }
        }
        ++self.tickCount;
    }

    public int getChargeAmount() {
        int amount = 0;
        if (this.getTier() >= 1) {
            amount += 4;
        }
        if (this.getTier() >= 2) {
            amount += 5;
            for (BlockPos pos : POOL_LOCATIONS) {
                ManaPoolBlockEntity pool;
                BlockEntity tile = this.m_58904_().m_7702_(this.m_58899_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                if (!(tile instanceof ManaPoolBlockEntity) || (pool = (ManaPoolBlockEntity)tile).getCurrentMana() < 10) continue;
                pool.receiveMana(-10);
                amount += 2;
            }
        }
        return amount;
    }

    public void updateTier() {
        this.setTier(0);
        if (new BlockPatternExtend(TIER_1_PATTERN).findFlat((LevelReader)this.m_58904_(), this.m_58899_()) != null) {
            this.setTier(1);
        }
        if (new BlockPatternExtend(TIER_2_PATTERN).findFlat((LevelReader)this.m_58904_(), this.m_58899_()) != null) {
            this.setTier(2);
        }
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, PedestalBlockEntity self) {
        ++self.tickCount;
    }

    public boolean tryAutoSmash(ItemStack hammer) {
        for (Recipe recipe : ExtraBotanyRecipeTypes.getRecipes(this.f_58857_, ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE).values()) {
            PedestalRecipe recipe2;
            if (!(recipe instanceof PedestalRecipe) || !(recipe2 = (PedestalRecipe)recipe).getSmashTools().test(hammer)) continue;
            if (!recipe2.getInput().test(this.getItem())) {
                if (!ItemStack.m_150942_((ItemStack)recipe2.getOutput(), (ItemStack)this.getItem())) continue;
                return false;
            }
            int expBoost = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)hammer);
            int efficiency = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)hammer);
            if (hammer.m_41763_() && hammer.m_220157_(1, this.f_58857_.f_46441_, null)) {
                this.automaticHammers.get(hammer).m_31805_(ItemStack.f_41583_);
            }
            ++this.strikes;
            if (this.strikes > 0 && this.strikes < recipe2.getStrike()) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12446_, SoundSource.BLOCKS, 0.8f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                return true;
            }
            ItemStack output = recipe2.getOutput().m_41777_();
            this.setItem(output);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.8f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            this.strikes = -1;
            return true;
        }
        return false;
    }

    public Map<ItemStack, ItemFrame> getPerhapsHammers() {
        return this.f_58857_.m_45976_(ItemFrame.class, new AABB(this.f_58858_).m_82400_(2.0)).stream().filter(frame -> frame.m_31748_().m_121945_(frame.m_6350_().m_122424_()).equals((Object)this.f_58858_)).filter(itemFrame -> !itemFrame.m_31822_().m_41619_()).collect(Collectors.toMap(ItemFrame::m_31822_, itemFrame -> itemFrame, (oldFrame, newFrame) -> newFrame));
    }

    public void updateAutomaticHammers() {
        this.automaticHammers = this.getPerhapsHammers();
        if (this.automaticHammers == null) {
            this.automaticHammers = new HashMap<ItemStack, ItemFrame>();
        }
    }

    @Override
    public int getStrikes() {
        return this.strikes;
    }

    @Override
    public void setStrikes(int strikes) {
        this.strikes = strikes;
    }

    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.setStrikes(tag.m_128451_("strikes"));
    }

    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.m_128405_("strikes", this.strikes);
    }

    public int getAnalogOutputSignal() {
        return this.strikes == -1 ? 15 : 0;
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.getItem().m_41619_();
    }

    public boolean m_7157_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.strikes == -1;
    }

    public static class HUD {
    }
}

