/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyMobEffects;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class TradeOrchidBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 8;
    public static final int MAX_MANA = 10000;
    public static final int MANA_PER_USE = 1000;
    public static final int COOLDOWN = 40;
    public static final double DISCOUNT_RATE = 0.5;

    public TradeOrchidBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.TRADE_ORCHID, pos, state);
    }

    public boolean acceptsRedstone() {
        return true;
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        if (this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % this.getCooldown() != 0) {
            return;
        }
        if (this.getMana() < this.getManaPerUse()) {
            return;
        }
        List<Villager> villagers = this.m_58904_().m_45976_(Villager.class, ((RadiusDescriptor.Rectangle)this.getRadius()).aabb()).stream().filter(villager -> !villager.m_213877_()).filter(LivingEntity::m_6084_).toList();
        List<Villager> farVillagers = this.m_58904_().m_45976_(Villager.class, ((RadiusDescriptor.Rectangle)this.getRadius()).aabb().m_82400_(5.0)).stream().filter(villager -> !villager.m_213877_()).filter(LivingEntity::m_6084_).filter(villager -> !villagers.contains(villager)).toList();
        for (Villager villager2 : villagers) {
            if (this.getMana() < this.getManaPerUse()) break;
            if (!villager2.m_7292_(this.getNewEffect())) continue;
            this.addMana(-this.getManaPerUse());
            this.sync();
        }
        for (Villager villager2 : farVillagers) {
            villager2.m_21195_(ExtraBotanyMobEffects.DISCOUNT);
        }
    }

    public void m_7651_() {
        List villagers = this.m_58904_().m_45976_(Villager.class, ((RadiusDescriptor.Rectangle)this.getRadius()).aabb());
        for (Villager villager : villagers) {
            villager.m_21195_(ExtraBotanyMobEffects.DISCOUNT);
        }
        super.m_7651_();
    }

    public int getCooldown() {
        return ExtraBotanyConfig.common().tradeOrchidCooldown();
    }

    public int getManaPerUse() {
        return ExtraBotanyConfig.common().tradeOrchidManaCost();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().tradeOrchidMaxMana();
    }

    public int getColor() {
        return 5565321;
    }

    public MobEffectInstance getNewEffect() {
        return new MobEffectInstance(ExtraBotanyMobEffects.DISCOUNT, ExtraBotanyConfig.common().tradeOrchidCooldown() + 20, this.calcRequireLevel(ExtraBotanyConfig.common().tradeOrchidDiscountPercentage()) - 1, true, false);
    }

    private int calcRequireLevel(double percentage) {
        percentage = Math.max(0.0, Math.min(1.0, percentage));
        return (int)Math.round((1.0 - percentage) * 100.0);
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)8);
    }
}

